/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class JdbcCriterion {
    final StringBuilder predicate = new StringBuilder();
    final List<Object> arguments = new ArrayList<Object>();
    protected String classifier = "msg_type";
    protected String sorter = "updated";
    protected Boolean reverse;

    public String getPredicate() {
        return this.predicate.length() == 0 ? "true" : this.predicate.toString();
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public Object[] getArgumentsAsArray() {
        return this.arguments.toArray(Object[]::new);
    }

    public String orderBy() {
        return this.sorter;
    }

    public String groupBy() {
        return this.classifier;
    }

    public Boolean reverse() {
        return this.reverse;
    }

    public String toString() {
        return "JdbcCriterion{(" + this.predicate + ")(" + this.arguments + ")}";
    }

    protected void addClause(String clause, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return;
        }
        if (this.predicate.length() > 0) {
            this.predicate.append(" AND ");
        }
        this.predicate.append(clause);
        this.arguments.addAll(Arrays.asList(arguments));
    }

    protected void addOrClause(String clause, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return;
        }
        if (this.predicate.length() > 0) {
            this.predicate.append(" AND ");
        }
        if (arguments.length > 1) {
            this.predicate.append("(");
        }
        for (int i = 0; i < arguments.length - 1; ++i) {
            this.predicate.append(clause).append(" OR ");
        }
        this.predicate.append(clause);
        if (arguments.length > 1) {
            this.predicate.append(")");
        }
        this.arguments.addAll(Arrays.asList(Arrays.stream(arguments).map(Object::toString).toArray()));
    }
}

