/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Args
implements Serializable {
    private static final long serialVersionUID = 4389995682226525641L;
    private final ImmutableListMultimap<String, String> _options;
    private final String _oneChar;
    private ImmutableList<String> _arguments;

    public Args(CharSequence args) {
        Scanner scanner = new Scanner();
        scanner.scan(args, false);
        this._options = scanner.options.build();
        this._arguments = scanner.arguments.build();
        this._oneChar = scanner.oneChar.toString();
    }

    public Args(String[] args) {
        this(Arrays.asList(args));
    }

    public Args(Iterable<String> args) {
        Scanner scanner = new Scanner();
        for (String arg : args) {
            if (arg.isEmpty()) {
                scanner.arguments.add((Object)"");
                continue;
            }
            scanner.scan(arg, true);
        }
        this._options = scanner.options.build();
        this._arguments = scanner.arguments.build();
        this._oneChar = scanner.oneChar.toString();
    }

    public Args(Args in) {
        this._arguments = in._arguments;
        this._options = in._options;
        this._oneChar = in._oneChar;
    }

    private Args(ImmutableList<String> arguments, ImmutableListMultimap<String, String> options, String oneChar) {
        this._arguments = arguments;
        this._options = options;
        this._oneChar = oneChar;
    }

    public static CharSequence quote(String raw) {
        if (raw.isEmpty()) {
            return "''";
        }
        StringBuilder sb = new StringBuilder();
        Args.quote(raw, sb);
        return sb;
    }

    public Args removeOptions(String ... names) {
        ListMultimap view = Multimaps.filterKeys(this._options, (Predicate)Predicates.not((Predicate)Predicates.in(Arrays.asList(names))));
        return new Args(this._arguments, (ImmutableListMultimap<String, String>)ImmutableListMultimap.copyOf((Multimap)view), this._oneChar);
    }

    public boolean isOneCharOption(char c) {
        return this._oneChar.indexOf(c) > -1;
    }

    public int argc() {
        return this._arguments.size();
    }

    public int optc() {
        return this._options.size();
    }

    public String getOpt(String name) {
        return this.getOption(name);
    }

    public double getDoubleOption(String name) {
        String option = this.getOption(name);
        if (option == null) {
            throw new NoSuchElementException("Option " + name + " does not exist.");
        }
        return Double.parseDouble(option);
    }

    public double getDoubleOption(String name, double defaultValue) {
        String option = this.getOption(name);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Option " + name + " does not have a value.");
        }
        return Double.parseDouble(option);
    }

    public int getIntOption(String name) {
        String option = this.getOption(name);
        if (option == null) {
            throw new NoSuchElementException("Option " + name + " does not exist.");
        }
        return Integer.parseInt(option);
    }

    public int getIntOption(String name, int defaultValue) {
        String option = this.getOption(name);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Option " + name + " does not have a value.");
        }
        return Integer.parseInt(option);
    }

    public long getLongOption(String name) {
        String option = this.getOption(name);
        if (option == null) {
            throw new NoSuchElementException("Option " + name + " does not exist.");
        }
        return Long.parseLong(option);
    }

    public long getLongOption(String name, long defaultValue) {
        String option = this.getOption(name);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Option " + name + " does not have a value.");
        }
        return Long.parseLong(option);
    }

    public boolean getBooleanOption(String name) {
        return this.getBooleanOption(name, false);
    }

    public boolean getBooleanOption(String name, boolean defaultValue) {
        String option = this.getOption(name);
        return option == null ? defaultValue : option.isEmpty() || Boolean.parseBoolean(option);
    }

    public String getOption(String name) {
        ImmutableList values = this._options.get((Object)name);
        return values.isEmpty() ? null : (String)values.get(values.size() - 1);
    }

    public String getOption(String name, String defaultValue) {
        ImmutableList values = this._options.get((Object)name);
        return values.isEmpty() ? defaultValue : (String)values.get(values.size() - 1);
    }

    public boolean hasOption(String name) {
        return !this._options.get((Object)name).isEmpty();
    }

    public ImmutableList<String> getOptions(String name) {
        return this._options.get((Object)name);
    }

    public String argv(int i) {
        return i < this._arguments.size() ? (String)this._arguments.get(i) : null;
    }

    public ImmutableList<String> getArguments() {
        return this._arguments;
    }

    public String optv(int i) {
        ImmutableMultiset keys = this._options.keys();
        return i < keys.size() ? (String)keys.asList().get(i) : null;
    }

    public void shift() {
        if (!this._arguments.isEmpty()) {
            this._arguments = this._arguments.subList(1, this._arguments.size());
        }
    }

    public void shift(int n) {
        this._arguments = this._arguments.subList(Math.min(n, this._arguments.size()), this._arguments.size());
    }

    public ImmutableListMultimap<String, String> options() {
        return this._options;
    }

    public ImmutableMap<String, String> optionsAsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this._options.entries()) {
            builder.put((Object)((String)e.getKey()), (Object)((String)e.getValue()));
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Args)) {
            return false;
        }
        Args args = (Args)other;
        return args._options.equals(this._options) && args._arguments.equals(this._arguments) && args._oneChar.equals(this._oneChar);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._options, this._arguments});
    }

    private static void quote(String in, StringBuilder out) {
        block8: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\\': {
                    out.append("\\\\");
                    continue block8;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    out.append("\\'");
                    continue block8;
                }
                case '=': {
                    out.append("\\=");
                    continue block8;
                }
                case '-': {
                    out.append("\\-");
                    continue block8;
                }
                case ' ': {
                    out.append("\\ ");
                    continue block8;
                }
                default: {
                    out.append(in.charAt(i));
                }
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry e : this._options.entries()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            s.append('-');
            Args.quote(key, s);
            if (!value.isEmpty()) {
                s.append('=');
                Args.quote(value, s);
            }
            s.append(' ');
        }
        if (s.length() > 0) {
            s.append("-- ");
        }
        Joiner.on((char)' ').appendTo(s, Iterables.transform(this._arguments, Args::quote));
        return s.toString();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Positional :\n");
        for (int i = 0; i < this._arguments.size(); ++i) {
            sb.append(i).append(" -> ").append((String)this._arguments.get(i)).append('\n');
        }
        sb.append("Options :\n");
        for (Map.Entry option : this._options.entries()) {
            sb.append((String)option.getKey());
            if (option.getValue() != null) {
                sb.append(" -> ").append((String)option.getValue());
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage : ... <parseString>");
            System.exit(4);
        }
        Args lineArgs = args.length == 1 ? new Args(args[0]) : new Args(args);
        System.out.print(lineArgs.getInfo());
        System.out.println("pvr=" + lineArgs.getOpt("pvr"));
    }

    private static class Scanner {
        final ImmutableListMultimap.Builder<String, String> options = new ImmutableListMultimap.Builder();
        final ImmutableList.Builder<String> arguments = new ImmutableList.Builder();
        final StringBuilder oneChar = new StringBuilder();
        private CharSequence line;
        private int position;
        private boolean isAtEndOfOptions;
        private boolean shouldIgnoreWhitespace;

        private char peek() {
            return this.isEof() ? (char)'\u0000' : this.line.charAt(this.position);
        }

        private char readChar() {
            char c = this.peek();
            ++this.position;
            return c;
        }

        private boolean isEof() {
            return this.position >= this.line.length();
        }

        private boolean isWhitespace() {
            return !this.shouldIgnoreWhitespace && Character.isWhitespace(this.peek());
        }

        private void scanWhitespace() {
            while (this.isWhitespace()) {
                this.readChar();
            }
        }

        public void scan(CharSequence line, boolean shouldIgnoreWhitespace) {
            this.line = line;
            this.shouldIgnoreWhitespace = shouldIgnoreWhitespace;
            this.position = 0;
            this.scanWhitespace();
            while (!this.isEof()) {
                if (!this.isAtEndOfOptions && this.peek() == '-') {
                    this.readChar();
                    String key = this.scanKey();
                    if (key.isEmpty()) {
                        this.arguments.add((Object)"-");
                    } else if (this.peek() == '=') {
                        this.readChar();
                        this.options.put((Object)key, (Object)this.scanWord());
                    } else if (key.equals("-")) {
                        this.isAtEndOfOptions = true;
                    } else {
                        this.options.put((Object)key, (Object)"");
                        this.oneChar.append(key);
                    }
                } else {
                    this.arguments.add((Object)this.scanWord());
                }
                this.scanWhitespace();
            }
        }

        private String scanKey() {
            StringBuilder key = new StringBuilder();
            do {
                this.scanWordElement(key);
            } while (!this.isEof() && !this.isWhitespace() && this.peek() != '=');
            return key.toString();
        }

        private String scanWord() {
            StringBuilder word = new StringBuilder();
            while (!this.isEof() && !this.isWhitespace()) {
                this.scanWordElement(word);
            }
            return word.toString();
        }

        private void scanWordElement(StringBuilder word) {
            if (!this.isEof() && !this.isWhitespace()) {
                switch (this.peek()) {
                    case '\'': {
                        this.scanSingleQuotedString(word);
                        break;
                    }
                    case '\"': {
                        this.scanDoubleQuotedString(word);
                        break;
                    }
                    case '\\': {
                        this.scanEscapedCharacter(word);
                        break;
                    }
                    default: {
                        word.append(this.readChar());
                    }
                }
            }
        }

        private void scanSingleQuotedString(StringBuilder word) {
            if (this.readChar() != '\'') {
                throw new IllegalStateException("Parse failure");
            }
            while (!this.isEof()) {
                char c = this.readChar();
                switch (c) {
                    case '\'': {
                        return;
                    }
                }
                word.append(c);
            }
        }

        private void scanDoubleQuotedString(StringBuilder word) {
            if (this.readChar() != '\"') {
                throw new IllegalStateException("Parse failure");
            }
            block4: while (!this.isEof()) {
                switch (this.peek()) {
                    case '\\': {
                        this.scanEscapedCharacter(word);
                        continue block4;
                    }
                    case '\"': {
                        this.readChar();
                        return;
                    }
                }
                word.append(this.readChar());
            }
        }

        private void scanEscapedCharacter(StringBuilder word) {
            if (this.readChar() != '\\') {
                throw new IllegalStateException("Parse failure");
            }
            if (!this.isEof()) {
                char c = this.readChar();
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '\'': 
                    case '-': 
                    case '=': 
                    case '\\': {
                        word.append(c);
                        break;
                    }
                    default: {
                        word.append('\\').append(c);
                    }
                }
            }
        }
    }
}

