/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.Monitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class BoundedExecutor
extends AbstractListeningExecutorService {
    private final Queue<Runnable> workQueue = new ArrayDeque<Runnable>();
    private final Executor executor;
    private final List<Thread> workers;
    private int maxThreads;
    private int maxQueued;
    private int threads;
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard isTerminated = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return BoundedExecutor.this.isShutdown && BoundedExecutor.this.threads == 0;
        }
    };
    private final Worker worker = new Worker();
    private boolean isShutdown;

    public BoundedExecutor(Executor executor, int maxThreads) {
        this(executor, maxThreads, Integer.MAX_VALUE);
    }

    public BoundedExecutor(Executor executor, int maxThreads, int maxQueued) {
        this.executor = executor;
        this.maxThreads = maxThreads;
        this.maxQueued = maxQueued;
        this.workers = new ArrayList<Thread>(maxThreads);
    }

    public void shutdown() {
        this.monitor.enter();
        try {
            this.isShutdown = true;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> shutdownNow() {
        this.monitor.enter();
        try {
            this.isShutdown = true;
            ArrayList<Runnable> unexecutedTasks = new ArrayList<Runnable>();
            unexecutedTasks.addAll(this.workQueue);
            this.workQueue.clear();
            for (Thread thread : this.workers) {
                thread.interrupt();
            }
            ArrayList<Runnable> arrayList = unexecutedTasks;
            return arrayList;
        }
        finally {
            this.monitor.leave();
        }
    }

    public boolean isShutdown() {
        this.monitor.enter();
        try {
            boolean bl = this.isShutdown;
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    public boolean isTerminated() {
        this.monitor.enter();
        try {
            boolean bl = this.isShutdown && this.threads == 0;
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.monitor.enter();
        try {
            boolean bl = this.monitor.waitFor(this.isTerminated, timeout, unit);
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    public void awaitTermination() throws InterruptedException {
        this.monitor.enter();
        try {
            this.monitor.waitFor(this.isTerminated);
        }
        finally {
            this.monitor.leave();
        }
    }

    public void awaitTerminationUninterruptibly() {
        this.monitor.enter();
        try {
            this.monitor.waitForUninterruptibly(this.isTerminated);
        }
        finally {
            this.monitor.leave();
        }
    }

    public void execute(Runnable task) {
        this.monitor.enter();
        try {
            if (this.isShutdown) {
                throw new RejectedExecutionException("Executor has been shut down.");
            }
            if (this.workQueue.size() - this.maxThreads + this.threads >= this.maxQueued) {
                throw new RejectedExecutionException("Executor queue limit has been reached.");
            }
            if (this.threads < this.maxThreads) {
                ++this.threads;
                this.executor.execute(this.worker);
            }
            this.workQueue.add(task);
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int size) {
        this.monitor.enter();
        try {
            this.maxThreads = size;
            int threadsToStart = Math.min(this.maxThreads - this.threads, this.workQueue.size());
            for (int i = 0; i < threadsToStart; ++i) {
                ++this.threads;
                this.executor.execute(this.worker);
            }
        }
        finally {
            this.monitor.leave();
        }
    }

    public int getMaximumPoolSize() {
        this.monitor.enter();
        try {
            int n = this.maxThreads;
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    public void setMaximumQueueSize(int size) {
        this.monitor.enter();
        try {
            this.maxQueued = size;
        }
        finally {
            this.monitor.leave();
        }
    }

    public int getMaximumQueueSize() {
        this.monitor.enter();
        try {
            int n = this.maxQueued;
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    public int getWorkQueueSize() {
        this.monitor.enter();
        try {
            int n = this.workQueue.size();
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    public int getThreadCount() {
        this.monitor.enter();
        try {
            int n = this.threads;
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        private Runnable getFirstTask() {
            BoundedExecutor.this.monitor.enter();
            try {
                if (BoundedExecutor.this.workQueue.isEmpty()) {
                    --BoundedExecutor.this.threads;
                    Runnable runnable = null;
                    return runnable;
                }
                BoundedExecutor.this.workers.add(Thread.currentThread());
                Runnable runnable = BoundedExecutor.this.workQueue.remove();
                return runnable;
            }
            finally {
                BoundedExecutor.this.monitor.leave();
            }
        }

        private Runnable getNextTask() {
            BoundedExecutor.this.monitor.enter();
            try {
                if (BoundedExecutor.this.workQueue.isEmpty() || BoundedExecutor.this.threads > BoundedExecutor.this.maxThreads) {
                    --BoundedExecutor.this.threads;
                    BoundedExecutor.this.workers.remove(Thread.currentThread());
                    Runnable runnable = null;
                    return runnable;
                }
                Runnable runnable = BoundedExecutor.this.workQueue.remove();
                return runnable;
            }
            finally {
                BoundedExecutor.this.monitor.leave();
            }
        }

        @Override
        public void run() {
            Runnable task = this.getFirstTask();
            while (task != null) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
                }
                task = this.getNextTask();
            }
        }
    }
}

