/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.util.ByteUnit;
import org.dcache.util.ByteUnits;

public class ByteSizeParser {
    private final List<Requirement> requirements;
    private final Whitespace whitespace;
    private final UnitPresence unitPresence;
    private final NumericalInput input;
    private final List<ByteUnits.Representation> representations;
    private final ByteUnit defaultUnits;
    private final Coercion coercion;
    private Pattern pattern;

    public static Builder using(ByteUnits.Representation ... representation) {
        return new Builder(Arrays.asList(representation));
    }

    private ByteSizeParser(Builder builder) {
        this.whitespace = builder.whitespace;
        this.unitPresence = builder.unitPresence;
        this.input = builder.input;
        this.representations = builder.representations;
        this.defaultUnits = builder.defaultUnits;
        this.coercion = builder.coercion;
        this.requirements = List.copyOf(builder.requirements);
    }

    private synchronized Pattern pattern() {
        if (this.pattern == null) {
            String whitespaceAndUnit = this.whitespace.regularExpression + "(?<unit>\\p{Alpha}+)";
            String whitespaceAndUnitWithPresence = this.unitPresence == UnitPresence.REQUIRED ? whitespaceAndUnit : "(?:" + whitespaceAndUnit + ")?";
            this.pattern = Pattern.compile("(?<number>" + this.input.regularExpression + ")" + whitespaceAndUnitWithPresence);
        }
        return this.pattern;
    }

    public long parse(String value, ByteUnit targetUnits) throws NumberFormatException {
        Matcher m = this.pattern().matcher(value);
        if (!m.matches()) {
            throw new NumberFormatException("Bad input \"" + value + "\" does not match " + this.pattern);
        }
        ByteUnit givenUnits = Optional.ofNullable(m.group("unit")).map(s -> this.parseUnit((String)s).orElseThrow(() -> new NumberFormatException("Unknown unit \"" + s + "\""))).orElse(this.defaultUnits);
        long size = this.input.convert(m.group("number"), givenUnits, targetUnits, this.coercion);
        this.requirements.stream().map(r -> r.rejectionMessage(size)).flatMap(Optional::stream).findFirst().map(IllegalArgumentException::new).ifPresent(e -> {
            throw e;
        });
        return size;
    }

    private Optional<ByteUnit> parseUnit(String unit) {
        return this.representations.stream().map(r -> r.parse(unit)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public long parse(String value) throws NumberFormatException {
        return this.parse(value, ByteUnit.BYTES);
    }

    public static class Builder {
        private final List<ByteUnits.Representation> representations;
        private final List<Requirement> requirements = new ArrayList<Requirement>();
        private NumericalInput input = NumericalInput.FLOATING_POINT;
        private Coercion coercion = Coercion.ROUND;
        private Whitespace whitespace = Whitespace.OPTIONAL;
        private UnitPresence unitPresence = UnitPresence.OPTIONAL;
        private ByteUnit defaultUnits = ByteUnit.BYTES;

        private Builder(List<ByteUnits.Representation> representations) {
            this.representations = Objects.requireNonNull(representations);
        }

        public Builder withCoersion(Coercion coersion) {
            this.coercion = Objects.requireNonNull(coersion);
            return this;
        }

        public Builder withInput(NumericalInput input) {
            this.input = Objects.requireNonNull(input);
            return this;
        }

        public Builder withWhitespace(Whitespace whitespace) {
            this.whitespace = Objects.requireNonNull(whitespace);
            return this;
        }

        public Builder withUnits(UnitPresence presence) {
            this.unitPresence = presence;
            return this;
        }

        public Builder requiring(LongPredicate requirement, String error) {
            this.requirements.add(new Requirement(requirement, error));
            return this;
        }

        public Builder withDefaultUnits(ByteUnit units) {
            this.defaultUnits = units;
            return this;
        }

        public ByteSizeParser build() {
            return new ByteSizeParser(this);
        }
    }

    public static enum Whitespace {
        REQUIRED(" "),
        OPTIONAL(" ?"),
        NOT_ALLOWED("");

        private final String regularExpression;

        private Whitespace(String re) {
            this.regularExpression = re;
        }
    }

    public static enum UnitPresence {
        OPTIONAL,
        REQUIRED;

    }

    public static enum Coercion {
        CEIL{

            @Override
            public long toLong(double value) {
                return (long)Math.ceil(value);
            }
        }
        ,
        FLOOR{

            @Override
            public long toLong(double value) {
                return (long)Math.floor(value);
            }
        }
        ,
        ROUND{

            @Override
            public long toLong(double value) {
                return Math.round(value);
            }
        };


        abstract long toLong(double var1);
    }

    public static enum NumericalInput {
        INTEGER("[-+]?\\d*"){

            @Override
            protected long convert(String givenValue, ByteUnit givenUnits, ByteUnit targetUnits, Coercion coersion) {
                return targetUnits.convert(Long.parseLong(givenValue), givenUnits);
            }
        }
        ,
        FLOATING_POINT("[-+]?\\d*(?:\\.\\d*)?"){

            @Override
            protected long convert(String givenValue, ByteUnit givenUnits, ByteUnit targetUnits, Coercion coersion) {
                double value = Double.parseDouble(givenValue);
                return coersion.toLong(targetUnits.convert(value, givenUnits));
            }
        };

        private final String regularExpression;

        private NumericalInput(String re) {
            this.regularExpression = re;
        }

        abstract long convert(String var1, ByteUnit var2, ByteUnit var3, Coercion var4);
    }

    private static class Requirement {
        private final LongPredicate requirement;
        private final String error;

        private Requirement(LongPredicate requirement, String error) {
            this.requirement = requirement;
            this.error = error;
        }

        public Optional<String> rejectionMessage(long value) {
            return this.requirement.test(value) ? Optional.empty() : Optional.of(this.error);
        }
    }
}

