/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;

public enum ByteUnit {
    BYTES{

        @Override
        public boolean hasType(Type type) {
            return true;
        }

        @Override
        public long toBytes(long d) {
            return d;
        }

        @Override
        public double toBytes(double d) {
            return d;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public double toKB(double d) {
            return d / 1000.0;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public double toKiB(double d) {
            return d / 1024.0;
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000L);
        }

        @Override
        public double toMB(double d) {
            return d / 1000000.0;
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x100000L);
        }

        @Override
        public double toMiB(double d) {
            return d / 1048576.0;
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000L);
        }

        @Override
        public double toGB(double d) {
            return d / 1.0E9;
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public double toGiB(double d) {
            return d / 1.073741824E9;
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public double toTB(double d) {
            return d / 1.0E12;
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public double toTiB(double d) {
            return d / 1.099511627776E12;
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000000L);
        }

        @Override
        public double toPB(double d) {
            return d / 1.0E15;
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x4000000000000L);
        }

        @Override
        public double toPiB(double d) {
            return d / 1.125899906842624E15;
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000000000L);
        }

        @Override
        public double toEB(double d) {
            return d / 1.0E18;
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x1000000000000000L);
        }

        @Override
        public double toEiB(double d) {
            return d / 1.152921504606847E18;
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toBytes(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toBytes(value);
        }
    }
    ,
    KB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1000.0;
        }

        @Override
        public long toKB(long d) {
            return d;
        }

        @Override
        public double toKB(double d) {
            return d;
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toKB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toKB(value);
        }
    }
    ,
    KiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1024.0;
        }

        @Override
        public long toKiB(long d) {
            return d;
        }

        @Override
        public double toKiB(double d) {
            return d;
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x4000000000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toKiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toKiB(value);
        }
    }
    ,
    MB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1000000.0;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public long toMB(long d) {
            return d;
        }

        @Override
        public double toMB(double d) {
            return d;
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toMB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toMB(value);
        }
    }
    ,
    MiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x100000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1048576.0;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public long toMiB(long d) {
            return d;
        }

        @Override
        public double toMiB(double d) {
            return d;
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toMiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toMiB(value);
        }
    }
    ,
    GB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.0E9;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public long toGB(long d) {
            return d;
        }

        @Override
        public double toGB(double d) {
            return d;
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toGB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toGB(value);
        }
    }
    ,
    GiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.073741824E9;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public long toGiB(long d) {
            return d;
        }

        @Override
        public double toGiB(double d) {
            return d;
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toGiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toGiB(value);
        }
    }
    ,
    TB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.0E12;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public long toTB(long d) {
            return d;
        }

        @Override
        public double toTB(double d) {
            return d;
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toTB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toTB(value);
        }
    }
    ,
    TiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.099511627776E12;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public long toTiB(long d) {
            return d;
        }

        @Override
        public double toTiB(double d) {
            return d;
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toTiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toTiB(value);
        }
    }
    ,
    PB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.0E15;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public long toPB(long d) {
            return d;
        }

        @Override
        public double toPB(double d) {
            return d;
        }

        @Override
        public long toEB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1000L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toPB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toPB(value);
        }
    }
    ,
    PiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x4000000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.125899906842624E15;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public long toPiB(long d) {
            return d;
        }

        @Override
        public double toPiB(double d) {
            return d;
        }

        @Override
        public long toEiB(long d) {
            return ByteUnit.divideKeepingSaturation(d, 1024L);
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toPiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toPiB(value);
        }
    }
    ,
    EB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.DECIMAL;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.0E18;
        }

        @Override
        public long toKB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000000L);
        }

        @Override
        public long toMB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000000L);
        }

        @Override
        public long toGB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000000L);
        }

        @Override
        public long toTB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000000L);
        }

        @Override
        public long toPB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1000L);
        }

        @Override
        public long toEB(long d) {
            return d;
        }

        @Override
        public double toEB(double d) {
            return d;
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toEB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toEB(value);
        }
    }
    ,
    EiB{

        @Override
        public boolean hasType(Type type) {
            return type == Type.BINARY;
        }

        @Override
        public long toBytes(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x1000000000000000L);
        }

        @Override
        public double toBytes(double d) {
            return d * 1.152921504606847E18;
        }

        @Override
        public long toKiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x4000000000000L);
        }

        @Override
        public long toMiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x10000000000L);
        }

        @Override
        public long toGiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x40000000L);
        }

        @Override
        public long toTiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 0x100000L);
        }

        @Override
        public long toPiB(long d) {
            return ByteUnit.multiplyKeepingSaturation(d, 1024L);
        }

        @Override
        public double toEiB(double d) {
            return d;
        }

        @Override
        public long convert(long value, ByteUnit units) {
            return units.toEiB(value);
        }

        @Override
        public double convert(double value, ByteUnit units) {
            return units.toEiB(value);
        }
    };


    public abstract boolean hasType(Type var1);

    private static long multiplyKeepingSaturation(long a, long b) throws ArithmeticException {
        if (a == Long.MAX_VALUE || b == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return LongMath.checkedMultiply((long)a, (long)b);
    }

    private static long divideKeepingSaturation(long dividend, long divisor) {
        if (dividend == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return dividend / divisor;
    }

    private static int checkedCast(long value) throws ArithmeticException {
        try {
            return Ints.checkedCast((long)value);
        }
        catch (IllegalArgumentException inner) {
            ArithmeticException e = new ArithmeticException(inner.getMessage());
            e.addSuppressed(inner);
            throw e;
        }
    }

    public abstract long convert(long var1, ByteUnit var3);

    public abstract double convert(double var1, ByteUnit var3);

    public int convert(int sourceValue, ByteUnit sourcePrefix) {
        if (sourceValue == Integer.MAX_VALUE) {
            return sourceValue;
        }
        return ByteUnit.checkedCast(this.convert((long)sourceValue, sourcePrefix));
    }

    public int toBytes(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toBytes((long)d));
    }

    public abstract long toBytes(long var1);

    public float toBytes(float d) {
        return (float)this.toBytes((double)d);
    }

    public abstract double toBytes(double var1);

    public int toKB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toKB((long)d));
    }

    public long toKB(long d) {
        return BYTES.toKB(this.toBytes(d));
    }

    public float toKB(float d) {
        return (float)this.toKB((double)d);
    }

    public double toKB(double d) {
        return BYTES.toKB(this.toBytes(d));
    }

    public int toKiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toKiB((long)d));
    }

    public long toKiB(long d) {
        return BYTES.toKiB(this.toBytes(d));
    }

    public float toKiB(float d) {
        return (float)this.toKiB((double)d);
    }

    public double toKiB(double d) {
        return BYTES.toKiB(this.toBytes(d));
    }

    public int toMB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toMB((long)d));
    }

    public long toMB(long d) {
        return BYTES.toMB(this.toBytes(d));
    }

    public float toMB(float d) {
        return (float)this.toMB((double)d);
    }

    public double toMB(double d) {
        return BYTES.toMB(this.toBytes(d));
    }

    public int toMiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toMiB((long)d));
    }

    public long toMiB(long d) {
        return BYTES.toMiB(this.toBytes(d));
    }

    public float toMiB(float d) {
        return (float)this.toMiB((double)d);
    }

    public double toMiB(double d) {
        return BYTES.toMiB(this.toBytes(d));
    }

    public long toGB(long d) {
        return BYTES.toGB(this.toBytes(d));
    }

    public int toGB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toGB((long)d));
    }

    public float toGB(float d) {
        return (float)this.toGB((double)d);
    }

    public double toGB(double d) {
        return BYTES.toGB(this.toBytes(d));
    }

    public long toGiB(long d) {
        return BYTES.toGiB(this.toBytes(d));
    }

    public int toGiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toGiB((long)d));
    }

    public float toGiB(float d) {
        return (float)this.toGiB((double)d);
    }

    public double toGiB(double d) {
        return BYTES.toGiB(this.toBytes(d));
    }

    public long toTB(long d) {
        return BYTES.toTB(this.toBytes(d));
    }

    public int toTB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toTB((long)d));
    }

    public float toTB(float d) {
        return (float)this.toTB((double)d);
    }

    public double toTB(double d) {
        return BYTES.toTB(this.toBytes(d));
    }

    public long toTiB(long d) {
        return BYTES.toTiB(this.toBytes(d));
    }

    public int toTiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toTiB((long)d));
    }

    public float toTiB(float d) {
        return (float)this.toTiB((double)d);
    }

    public double toTiB(double d) {
        return BYTES.toTiB(this.toBytes(d));
    }

    public long toPB(long d) {
        return BYTES.toPB(this.toBytes(d));
    }

    public int toPB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toPB((long)d));
    }

    public float toPB(float d) {
        return (float)this.toPB((double)d);
    }

    public double toPB(double d) {
        return BYTES.toPB(this.toBytes(d));
    }

    public long toPiB(long d) {
        return BYTES.toPiB(this.toBytes(d));
    }

    public int toPiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toPiB((long)d));
    }

    public float toPiB(float d) {
        return (float)this.toPiB((double)d);
    }

    public double toPiB(double d) {
        return BYTES.toPiB(this.toBytes(d));
    }

    public long toEB(long d) {
        return BYTES.toEB(this.toBytes(d));
    }

    public int toEB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toEB((long)d));
    }

    public float toEB(float d) {
        return (float)this.toEB((double)d);
    }

    public double toEB(double d) {
        return BYTES.toEB(this.toBytes(d));
    }

    public long toEiB(long d) {
        return BYTES.toEiB(this.toBytes(d));
    }

    public int toEiB(int d) {
        if (d == Integer.MAX_VALUE) {
            return d;
        }
        return ByteUnit.checkedCast(this.toEiB((long)d));
    }

    public float toEiB(float d) {
        return (float)this.toEiB((double)d);
    }

    public double toEiB(double d) {
        return BYTES.toEiB(this.toBytes(d));
    }

    public static enum Type {
        DECIMAL{

            @Override
            public ByteUnit unitsOf(long value, long minValue) {
                long absValue;
                long l = absValue = value == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(value);
                if (absValue < KB.toBytes(minValue)) {
                    return BYTES;
                }
                if (absValue < MB.toBytes(minValue)) {
                    return KB;
                }
                if (absValue < GB.toBytes(minValue)) {
                    return MB;
                }
                if (absValue < TB.toBytes(minValue)) {
                    return GB;
                }
                if (absValue < PB.toBytes(minValue)) {
                    return TB;
                }
                if (absValue < EB.toBytes(minValue)) {
                    return PB;
                }
                return EB;
            }

            @Override
            public ByteUnit unitsOf(double value, double minValue) {
                double absValue = Math.abs(value);
                if (absValue < KB.toBytes(minValue)) {
                    return BYTES;
                }
                if (absValue < MB.toBytes(minValue)) {
                    return KB;
                }
                if (absValue < GB.toBytes(minValue)) {
                    return MB;
                }
                if (absValue < TB.toBytes(minValue)) {
                    return GB;
                }
                if (absValue < PB.toBytes(minValue)) {
                    return TB;
                }
                if (absValue < EB.toBytes(minValue)) {
                    return PB;
                }
                return EB;
            }

            @Override
            public ByteUnit exactUnitsOf(long value) {
                long absValue = Math.abs(value);
                if (absValue >= EB.toBytes(1L) && absValue % EB.toBytes(1L) == 0L) {
                    return EB;
                }
                if (absValue >= PB.toBytes(1L) && absValue % PB.toBytes(1L) == 0L) {
                    return PB;
                }
                if (absValue >= TB.toBytes(1L) && absValue % TB.toBytes(1L) == 0L) {
                    return TB;
                }
                if (absValue >= GB.toBytes(1L) && absValue % GB.toBytes(1L) == 0L) {
                    return GB;
                }
                if (absValue >= MB.toBytes(1L) && absValue % MB.toBytes(1L) == 0L) {
                    return MB;
                }
                if (absValue >= KB.toBytes(1L) && absValue % KB.toBytes(1L) == 0L) {
                    return KB;
                }
                return BYTES;
            }
        }
        ,
        BINARY{

            @Override
            public ByteUnit unitsOf(long value, long minValue) {
                long absValue;
                long l = absValue = value == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(value);
                if (absValue < KiB.toBytes(minValue)) {
                    return BYTES;
                }
                if (absValue < MiB.toBytes(minValue)) {
                    return KiB;
                }
                if (absValue < GiB.toBytes(minValue)) {
                    return MiB;
                }
                if (absValue < TiB.toBytes(minValue)) {
                    return GiB;
                }
                if (absValue < PiB.toBytes(minValue)) {
                    return TiB;
                }
                if (absValue < EiB.toBytes(minValue)) {
                    return PiB;
                }
                return EiB;
            }

            @Override
            public ByteUnit unitsOf(double value, double minValue) {
                double absValue = Math.abs(value);
                if (absValue < KiB.toBytes(minValue)) {
                    return BYTES;
                }
                if (absValue < MiB.toBytes(minValue)) {
                    return KiB;
                }
                if (absValue < GiB.toBytes(minValue)) {
                    return MiB;
                }
                if (absValue < TiB.toBytes(minValue)) {
                    return GiB;
                }
                if (absValue < PiB.toBytes(minValue)) {
                    return TiB;
                }
                if (absValue < EiB.toBytes(minValue)) {
                    return PiB;
                }
                return EiB;
            }

            @Override
            public ByteUnit exactUnitsOf(long value) {
                long absValue = Math.abs(value);
                if (absValue >= EiB.toBytes(1L) && absValue % EiB.toBytes(1L) == 0L) {
                    return EiB;
                }
                if (absValue >= PiB.toBytes(1L) && absValue % PiB.toBytes(1L) == 0L) {
                    return PiB;
                }
                if (absValue >= TiB.toBytes(1L) && absValue % TiB.toBytes(1L) == 0L) {
                    return TiB;
                }
                if (absValue >= GiB.toBytes(1L) && absValue % GiB.toBytes(1L) == 0L) {
                    return GiB;
                }
                if (absValue >= MiB.toBytes(1L) && absValue % MiB.toBytes(1L) == 0L) {
                    return MiB;
                }
                if (absValue >= KiB.toBytes(1L) && absValue % KiB.toBytes(1L) == 0L) {
                    return KiB;
                }
                return BYTES;
            }
        };


        public ByteUnit unitsOf(long value) {
            return this.unitsOf(value, 1L);
        }

        public abstract ByteUnit unitsOf(long var1, long var3);

        public ByteUnit unitsOf(double value) {
            return this.unitsOf(value, 1.0);
        }

        public abstract ByteUnit unitsOf(double var1, double var3);

        public abstract ByteUnit exactUnitsOf(long var1);
    }
}

