/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.util.Optional;
import org.dcache.util.ByteUnit;

public class ByteUnits {
    private static final Representation ISO_PREFIX = new IsoPrefix();
    private static final Representation JEDEC_PREFIX = new JedecPrefix();
    private static final Representation ISO_SYMBOL = new IsoUnit();
    private static final Representation JEDEC_SYMBOL = new JedecUnit();

    private ByteUnits() {
    }

    public static Representation isoPrefix() {
        return ISO_PREFIX;
    }

    public static Representation jedecPrefix() {
        return JEDEC_PREFIX;
    }

    public static Representation isoSymbol() {
        return ISO_SYMBOL;
    }

    public static Representation jedecSymbol() {
        return JEDEC_SYMBOL;
    }

    public static class JedecUnit
    implements Representation {
        @Override
        public String of(ByteUnit unit) {
            switch (unit) {
                case BYTES: {
                    return "B";
                }
                case KiB: {
                    return "KB";
                }
                case MiB: {
                    return "MB";
                }
                case GiB: {
                    return "GB";
                }
                case TiB: {
                    return "TB";
                }
                case PiB: {
                    return "PB";
                }
                case EiB: {
                    return "EB";
                }
            }
            throw new UnsupportedOperationException("no JEDEC unit for " + unit.name());
        }

        @Override
        public Optional<ByteUnit> parse(String value) {
            switch (value) {
                case "B": {
                    return Optional.of(ByteUnit.BYTES);
                }
                case "kB": 
                case "KB": {
                    return Optional.of(ByteUnit.KiB);
                }
                case "MB": {
                    return Optional.of(ByteUnit.MiB);
                }
                case "GB": {
                    return Optional.of(ByteUnit.GiB);
                }
                case "TB": {
                    return Optional.of(ByteUnit.TiB);
                }
                case "PB": {
                    return Optional.of(ByteUnit.PiB);
                }
                case "EB": {
                    return Optional.of(ByteUnit.EiB);
                }
            }
            return Optional.empty();
        }
    }

    public static class JedecPrefix
    implements Representation {
        @Override
        public String of(ByteUnit unit) {
            switch (unit) {
                case BYTES: {
                    return "";
                }
                case KiB: {
                    return "K";
                }
                case MiB: {
                    return "M";
                }
                case GiB: {
                    return "G";
                }
                case TiB: {
                    return "T";
                }
                case PiB: {
                    return "P";
                }
                case EiB: {
                    return "E";
                }
            }
            throw new UnsupportedOperationException("no JEDEC prefix for " + unit.name());
        }

        @Override
        public Optional<ByteUnit> parse(String value) {
            switch (value) {
                case "": {
                    return Optional.of(ByteUnit.BYTES);
                }
                case "k": 
                case "K": {
                    return Optional.of(ByteUnit.KiB);
                }
                case "M": {
                    return Optional.of(ByteUnit.MiB);
                }
                case "G": {
                    return Optional.of(ByteUnit.GiB);
                }
                case "T": {
                    return Optional.of(ByteUnit.TiB);
                }
                case "P": {
                    return Optional.of(ByteUnit.PiB);
                }
                case "E": {
                    return Optional.of(ByteUnit.EiB);
                }
            }
            return Optional.empty();
        }
    }

    public static class IsoUnit
    implements Representation {
        @Override
        public String of(ByteUnit unit) {
            switch (unit) {
                case BYTES: {
                    return "B";
                }
                case KiB: {
                    return "KiB";
                }
                case MiB: {
                    return "MiB";
                }
                case GiB: {
                    return "GiB";
                }
                case TiB: {
                    return "TiB";
                }
                case PiB: {
                    return "PiB";
                }
                case EiB: {
                    return "EiB";
                }
                case KB: {
                    return "kB";
                }
                case MB: {
                    return "MB";
                }
                case GB: {
                    return "GB";
                }
                case TB: {
                    return "TB";
                }
                case PB: {
                    return "PB";
                }
                case EB: {
                    return "EB";
                }
            }
            throw new UnsupportedOperationException("no ISO unit for " + unit.name());
        }

        @Override
        public Optional<ByteUnit> parse(String value) {
            switch (value) {
                case "B": {
                    return Optional.of(ByteUnit.BYTES);
                }
                case "KiB": {
                    return Optional.of(ByteUnit.KiB);
                }
                case "MiB": {
                    return Optional.of(ByteUnit.MiB);
                }
                case "GiB": {
                    return Optional.of(ByteUnit.GiB);
                }
                case "TiB": {
                    return Optional.of(ByteUnit.TiB);
                }
                case "PiB": {
                    return Optional.of(ByteUnit.PiB);
                }
                case "EiB": {
                    return Optional.of(ByteUnit.EiB);
                }
                case "kB": {
                    return Optional.of(ByteUnit.KB);
                }
                case "MB": {
                    return Optional.of(ByteUnit.MB);
                }
                case "GB": {
                    return Optional.of(ByteUnit.GB);
                }
                case "TB": {
                    return Optional.of(ByteUnit.TB);
                }
                case "PB": {
                    return Optional.of(ByteUnit.PB);
                }
                case "EB": {
                    return Optional.of(ByteUnit.EB);
                }
            }
            return Optional.empty();
        }
    }

    public static class IsoPrefix
    implements Representation {
        @Override
        public String of(ByteUnit unit) {
            switch (unit) {
                case BYTES: {
                    return "";
                }
                case KiB: {
                    return "Ki";
                }
                case MiB: {
                    return "Mi";
                }
                case GiB: {
                    return "Gi";
                }
                case TiB: {
                    return "Ti";
                }
                case PiB: {
                    return "Pi";
                }
                case EiB: {
                    return "Ei";
                }
                case KB: {
                    return "k";
                }
                case MB: {
                    return "M";
                }
                case GB: {
                    return "G";
                }
                case TB: {
                    return "T";
                }
                case PB: {
                    return "P";
                }
                case EB: {
                    return "E";
                }
            }
            throw new UnsupportedOperationException("no ISO prefix for " + unit.name());
        }

        @Override
        public Optional<ByteUnit> parse(String value) {
            switch (value) {
                case "": {
                    return Optional.of(ByteUnit.BYTES);
                }
                case "Ki": {
                    return Optional.of(ByteUnit.KiB);
                }
                case "Mi": {
                    return Optional.of(ByteUnit.MiB);
                }
                case "Gi": {
                    return Optional.of(ByteUnit.GiB);
                }
                case "Ti": {
                    return Optional.of(ByteUnit.TiB);
                }
                case "Pi": {
                    return Optional.of(ByteUnit.PiB);
                }
                case "Ei": {
                    return Optional.of(ByteUnit.EiB);
                }
                case "k": {
                    return Optional.of(ByteUnit.KB);
                }
                case "M": {
                    return Optional.of(ByteUnit.MB);
                }
                case "G": {
                    return Optional.of(ByteUnit.GB);
                }
                case "T": {
                    return Optional.of(ByteUnit.TB);
                }
                case "P": {
                    return Optional.of(ByteUnit.PB);
                }
                case "E": {
                    return Optional.of(ByteUnit.EB);
                }
            }
            return Optional.empty();
        }
    }

    public static interface Representation {
        public String of(ByteUnit var1);

        public Optional<ByteUnit> parse(String var1);
    }
}

