/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

public final class Bytes {
    private Bytes() {
    }

    public static void putLong(byte[] bytes, int offset, long value) throws IllegalArgumentException {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("not enough space to store long");
        }
        bytes[offset] = (byte)(value >> 56);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static void putInt(byte[] bytes, int offset, int value) throws IllegalArgumentException {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("not enough space to store int");
        }
        bytes[offset] = (byte)(value >> 24);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static long getLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static int getInt(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }
}

