/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Callables {
    private Callables() {
    }

    public static <T> Callable<T> memoizeWithExpiration(Callable<T> delegate, long duration, TimeUnit unit) {
        return new ExpiringMemoizingCallable<T>(delegate, duration, unit);
    }

    public static <T> Callable<T> memoizeFromFiles(Callable<T> delegate, Path ... files) {
        return new MemoizingCallableFromFiles<T>(delegate, files);
    }

    private static class MemoizingCallableFromFiles<T>
    implements Callable<T> {
        final Path[] files;
        final Callable<T> delegate;
        FileTime lastLastModifiedTime;
        T value;

        public MemoizingCallableFromFiles(Callable<T> delegate, Path[] files) {
            this.delegate = delegate;
            this.files = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            FileTime lastModified = this.getLastModifiedTime();
            MemoizingCallableFromFiles memoizingCallableFromFiles = this;
            synchronized (memoizingCallableFromFiles) {
                if (lastModified == null || this.lastLastModifiedTime == null || lastModified.compareTo(this.lastLastModifiedTime) > 0) {
                    this.value = this.delegate.call();
                    this.lastLastModifiedTime = lastModified;
                }
                return this.value;
            }
        }

        private FileTime getLastModifiedTime() {
            if (this.files.length == 0) {
                return null;
            }
            try {
                FileTime max = Files.getLastModifiedTime(this.files[0], new LinkOption[0]);
                for (int i = 1; i < this.files.length; ++i) {
                    FileTime t = Files.getLastModifiedTime(this.files[i], new LinkOption[0]);
                    if (t.compareTo(max) <= 0) continue;
                    max = t;
                }
                return max;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class ExpiringMemoizingCallable<T>
    implements Callable<T> {
        final Callable<T> delegate;
        final long durationNanos;
        volatile transient T value;
        volatile transient long expirationNanos;

        ExpiringMemoizingCallable(Callable<T> delegate, long duration, TimeUnit unit) {
            Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0);
            this.delegate = Objects.requireNonNull(delegate);
            this.durationNanos = unit.toNanos(duration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            long nanos = this.expirationNanos;
            long now = System.nanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                ExpiringMemoizingCallable expiringMemoizingCallable = this;
                synchronized (expiringMemoizingCallable) {
                    if (nanos == this.expirationNanos) {
                        T t = this.delegate.call();
                        this.value = t;
                        nanos = now + this.durationNanos;
                        this.expirationNanos = nanos == 0L ? 1L : nanos;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            return "Suppliers.memoizeWithExpiration(" + this.delegate + ", " + this.durationNanos + ", NANOS)";
        }
    }
}

