/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertificateFactories {
    public static final String X_509 = "X.509";

    private CertificateFactories() {
    }

    public static CertificateFactory newX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance(X_509, "BC");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to create X.509 certificate factory: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Failed to load bouncy castle provider: " + e.getMessage(), e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

