/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Objects;
import org.dcache.util.ChecksumType;

public class Checksum
implements Serializable {
    private static final long serialVersionUID = 7338775749513974986L;
    private static final CharMatcher HEXADECIMAL = CharMatcher.anyOf((CharSequence)"0123456789abcdef");
    private static final char DELIMITER = ':';
    private final ChecksumType type;
    private final String value;

    public Checksum(ChecksumType type, byte[] value) {
        this(type, BaseEncoding.base16().lowerCase().encode(value));
    }

    public Checksum(MessageDigest digest) {
        this(ChecksumType.getChecksumType(digest.getAlgorithm()), digest.digest());
    }

    public Checksum(ChecksumType type, String value) {
        Objects.requireNonNull(type, "type may not be null");
        Objects.requireNonNull(value, "value may not be null");
        this.type = type;
        this.value = Checksum.normalise(type, value);
        Preconditions.checkArgument((boolean)HEXADECIMAL.matchesAllOf((CharSequence)this.value), (String)"checksum value \"%s\" contains non-hexadecimal digits", (Object)value);
        Preconditions.checkArgument((this.value.length() == type.getNibbles() ? 1 : 0) != 0, (String)"%s requires %s hexadecimal digits but \"%s\" has %s", (Object)type.getName(), (Object)type.getNibbles(), (Object)value, (Object)this.value.length());
    }

    public static Checksum fromBase64Value(ChecksumType type, String value) {
        byte[] bytes = Base64.getDecoder().decode(value);
        return new Checksum(type, bytes);
    }

    public static boolean isValid(ChecksumType type, String value) {
        String normalised = Checksum.normalise(type, value);
        return HEXADECIMAL.matchesAllOf((CharSequence)normalised) && normalised.length() == type.getNibbles();
    }

    private static String normalise(ChecksumType type, String value) {
        String normalised = value.trim().toLowerCase();
        if (type == ChecksumType.ADLER32) {
            normalised = Strings.padStart((String)normalised, (int)type.getNibbles(), (char)'0');
        }
        return normalised;
    }

    public ChecksumType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Checksum that = (Checksum)other;
        return this.type == that.type && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.type.getType() + ":" + this.value;
    }

    public static Checksum parseChecksum(String digest) {
        Objects.requireNonNull(digest, "value may not be null");
        int del = digest.indexOf(58);
        if (del < 1) {
            throw new IllegalArgumentException("Not a dCache checksum: " + digest);
        }
        String type = digest.substring(0, del);
        String checksum = digest.substring(del + 1);
        return new Checksum(ChecksumType.getChecksumType(type), checksum);
    }
}

