/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.Adler32;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.dcache.util.Checksum;

public enum ChecksumType {
    ADLER32(1, "ADLER32", 32){

        @Override
        public MessageDigest createMessageDigest() {
            return new Adler32();
        }
    }
    ,
    MD5_TYPE(2, "MD5", 128),
    MD4_TYPE(3, "MD4", 128),
    SHA1(4, "SHA-1", 160),
    SHA256(5, "SHA-256", 256),
    SHA512(6, "SHA-512", 512);

    private final int type;
    private final String name;
    private final int bits;

    private ChecksumType(int type, String name, int bits) {
        this.type = type;
        this.name = name;
        this.bits = bits;
    }

    public static final ChecksumType getChecksumType(int i) {
        for (ChecksumType type : ChecksumType.values()) {
            if (type.type != i) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + i);
    }

    public static final ChecksumType getChecksumType(String s) {
        for (ChecksumType type : ChecksumType.values()) {
            if (!type.name.equalsIgnoreCase(s) && !String.valueOf(type.type).equals(s)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + s);
    }

    public static final boolean isValid(String s) {
        return Arrays.stream(ChecksumType.values()).map(ChecksumType::getName).anyMatch(x -> x.equalsIgnoreCase(s));
    }

    public int getType() {
        return this.type;
    }

    public MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(this.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This is a bug in ChecksumType: " + e.getMessage(), e);
        }
    }

    public Checksum calculate(byte[] data) {
        return new Checksum(this, this.createMessageDigest().digest(data));
    }

    public String getName() {
        return this.name;
    }

    public int getBits() {
        return this.bits;
    }

    public int getNibbles() {
        return (this.bits + 3) / 4;
    }

    public String toString() {
        return this.getName();
    }
}

