/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.dcache.util.ByteUnit;
import org.dcache.util.ByteUnits;
import org.dcache.util.NoTrailingWhitespacePrintWriter;

public class ColumnWriter {
    private final List<String> headers = new ArrayList<String>();
    private final List<Integer> spaces = new ArrayList<Integer>();
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Row> rows = new ArrayList<Row>();
    private boolean headersAffectRowWidth;
    private String renderedHeader;
    private boolean noheader;

    public ColumnWriter() {
        this.spaces.add(0);
    }

    public ColumnWriter suppressHeaders() {
        this.noheader = true;
        return this;
    }

    private void addColumn(Column column) {
        this.columns.add(column);
        if (this.headers.size() < this.columns.size()) {
            this.headers.add(null);
        }
        this.spaces.add(0);
    }

    public ColumnWriter left(String name) {
        this.addColumn(new LeftColumn(name));
        return this;
    }

    public ColumnWriter centre(String name) {
        this.addColumn(new CentreColumn(name));
        return this;
    }

    public ColumnWriter right(String name) {
        this.addColumn(new RightColumn(name));
        return this;
    }

    public ColumnWriter bytes(String name, ByteUnit units) {
        this.addColumn(new FixedScalingByteColumn(name, units));
        return this;
    }

    public ColumnWriter bytes(String name, ByteUnit units, String nullValue) {
        this.addColumn(new FixedScalingByteColumn(name, units, nullValue));
        return this;
    }

    public ColumnWriter bytes(String name, ByteUnit.Type displayUnits) {
        this.addColumn(new HumanReadableByteColumn(name, displayUnits));
        return this;
    }

    public ColumnWriter bytes(String name, ByteUnit.Type displayUnits, String nullValue) {
        this.addColumn(new HumanReadableByteColumn(name, displayUnits, nullValue));
        return this;
    }

    public ColumnWriter bytes(String name, Optional<ByteUnit> units, ByteUnit.Type displayUnits) {
        if (units.isPresent()) {
            return this.bytes(name, units.get());
        }
        return this.bytes(name, displayUnits);
    }

    public ColumnWriter bytes(String name, Optional<ByteUnit> units, ByteUnit.Type displayUnits, String nullValue) {
        if (units.isPresent()) {
            return this.bytes(name, units.get(), nullValue);
        }
        return this.bytes(name, displayUnits, nullValue);
    }

    public ColumnWriter fixed(String value) {
        this.addColumn(new FixedColumn(value));
        return this;
    }

    public ColumnWriter space() {
        int last = this.spaces.size() - 1;
        this.spaces.set(last, this.spaces.get(last) + 1);
        return this;
    }

    public ColumnWriter headersInColumns() {
        this.headersAffectRowWidth = true;
        return this;
    }

    public TabulatedRow row() {
        TabulatedRow row = new TabulatedRow();
        this.rows.add(row);
        return row;
    }

    public void row(String value) {
        this.rows.add(new LiteralRow(value));
    }

    public void section(String title) {
        this.rows.add(new SectionRow(title));
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String endOfLine) {
        if (this.rows.isEmpty()) {
            return "";
        }
        StringWriter result = new StringWriter();
        try (NoTrailingWhitespacePrintWriter out = new NoTrailingWhitespacePrintWriter(result);){
            this.printTo(out, endOfLine);
        }
        return result.toString();
    }

    public void printTo(PrintWriter out) {
        this.printTo(out, "\n");
    }

    private void printTo(PrintWriter out, String endOfLine) {
        List<Integer> widths = this.calculateWidths();
        ArrayList<Integer> spaces = new ArrayList<Integer>(this.spaces);
        this.renderedHeader = this.noheader ? "" : this.renderHeader(spaces, widths);
        Row previousRow = null;
        for (Row row : this.rows) {
            row.render(previousRow, this.columns, spaces, widths, out, endOfLine);
            previousRow = row;
        }
    }

    private void printHeader(PrintWriter out, String endOfLine) {
        if (!this.renderedHeader.isEmpty()) {
            out.print(this.renderedHeader);
            out.print(endOfLine);
        }
    }

    private List<Integer> calculateWidths() {
        int columnCount = this.columns.size();
        int[] widths = new int[columnCount];
        if (this.headersAffectRowWidth) {
            for (int i = 0; i < columnCount; ++i) {
                String header = this.headers.get(i);
                widths[i] = header == null ? 0 : header.length();
            }
        }
        for (Row row : this.rows) {
            for (int i = 0; i < columnCount; ++i) {
                widths[i] = Math.max(widths[i], row.width(this.columns.get(i)));
            }
        }
        return Ints.asList((int[])widths);
    }

    private String renderHeader(List<Integer> spaces, List<Integer> widths) {
        int columnCount = this.columns.size();
        StringBuilder line = new StringBuilder();
        int columnEnd = 0;
        for (int i = 0; i < columnCount; ++i) {
            String header = this.headers.get(i);
            if (header != null) {
                int headerStart = columnEnd + spaces.get(i) + this.columns.get(i).headerIndentation(header.length(), widths.get(i));
                if (!this.headersAffectRowWidth && line.length() >= headerStart) {
                    int newHeaderStart = line.length() > 0 ? line.length() + 1 : 0;
                    spaces.set(i, spaces.get(i) + newHeaderStart - headerStart);
                    headerStart = newHeaderStart;
                }
                for (int c = line.length(); c < headerStart; ++c) {
                    line.append(' ');
                }
                line.append(header);
            }
            columnEnd = columnEnd + spaces.get(i) + widths.get(i);
        }
        return line.toString();
    }

    public ColumnWriter date(String name) {
        this.addColumn(new DateColumn(name));
        return this;
    }

    public ColumnWriter date(String name, DateStyle style) {
        this.addColumn(new DateColumn(name, style));
        return this;
    }

    public ColumnWriter header(String text) {
        this.headers.add(text);
        this.renderedHeader = null;
        return this;
    }

    private static class SectionRow
    implements Row {
        private final String title;

        private SectionRow(String title) {
            this.title = title;
        }

        @Override
        public int width(Column column) {
            return 0;
        }

        @Override
        public void render(Row previous, List<Column> columns, List<Integer> spaces, List<Integer> widths, PrintWriter out, String endOfLine) {
            if (previous != null) {
                out.print(endOfLine);
            }
            out.print(this.title);
            out.print(endOfLine);
            out.print(endOfLine);
        }
    }

    private class LiteralRow
    implements Row {
        private final String value;

        private LiteralRow(String value) {
            this.value = value;
        }

        @Override
        public int width(Column column) {
            return 0;
        }

        @Override
        public void render(Row previous, List<Column> columns, List<Integer> spaces, List<Integer> widths, PrintWriter out, String endOfLine) {
            if (!(previous instanceof TabulatedRow) && !(previous instanceof LiteralRow)) {
                ColumnWriter.this.printHeader(out, endOfLine);
            }
            out.print(this.value);
            out.print(endOfLine);
        }
    }

    public class TabulatedRow
    implements Row {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final Map<String, String> fills = new HashMap<String, String>();

        public TabulatedRow value(String column, Object value) {
            this.values.put(column, value);
            return this;
        }

        public TabulatedRow fill(String column, String value) {
            this.fills.put(column, value);
            return this;
        }

        @Override
        public int width(Column column) {
            return column.width(this.values.get(column.name()));
        }

        @Override
        public void render(Row previous, List<Column> columns, List<Integer> spaces, List<Integer> widths, PrintWriter out, String endOfLine) {
            if (!(previous instanceof TabulatedRow) && !(previous instanceof LiteralRow)) {
                ColumnWriter.this.printHeader(out, endOfLine);
            }
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String fill;
                for (int c = spaces.get(i).intValue(); c > 0; --c) {
                    out.append(' ');
                }
                Column column = columns.get(i);
                Object value = this.values.get(column.name());
                int width = widths.get(i);
                if (value == null && (fill = this.fills.get(column.name())) != null) {
                    int count = (width + width % fill.length()) / fill.length();
                    value = Strings.repeat((String)fill, (int)count).subSequence(0, width);
                }
                column.render(value, width, out);
            }
            out.print(endOfLine);
        }
    }

    private static interface Row {
        public int width(Column var1);

        public void render(Row var1, List<Column> var2, List<Integer> var3, List<Integer> var4, PrintWriter var5, String var6);
    }

    private static class DateColumn
    extends AbstractColumn {
        public static final String ISO_FORMAT = "%1$tF %1$tT";
        public static final String LS_YEAR_FORMAT = "%1$tb %1$2te  %1$tY";
        public static final String LS_NO_YEAR_FORMAT = "%1$tb %1$2te %1$tR";
        public static final int WIDTH_OF_ISO_FORMAT = 19;
        public static final int WIDTH_OF_LS_FORMAT = 12;
        public final DateStyle style;
        private final long sixMonthsInPast;
        private final long oneHourInFuture;

        public DateColumn(String name) {
            this(name, DateStyle.ISO);
        }

        public DateColumn(String name, DateStyle style) {
            super(name);
            this.style = style;
            this.oneHourInFuture = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -6);
            this.sixMonthsInPast = calendar.getTimeInMillis();
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return Math.max(columnWidth - headerWidth, 0);
        }

        @Override
        public int width(Object value) {
            switch (this.style) {
                case ISO: {
                    return 19;
                }
                case LS: {
                    return 12;
                }
            }
            throw new RuntimeException("Unknown style: " + this.style);
        }

        private String getFormat(Object value) {
            switch (this.style) {
                case ISO: {
                    return ISO_FORMAT;
                }
                case LS: {
                    Date when = (Date)value;
                    if (when.getTime() < this.sixMonthsInPast || when.getTime() > this.oneHourInFuture) {
                        return LS_YEAR_FORMAT;
                    }
                    return LS_NO_YEAR_FORMAT;
                }
            }
            throw new RuntimeException("Unknown style: " + this.style);
        }

        @Override
        public void render(Object value, int actualWidth, PrintWriter out) {
            if (value == null) {
                while (actualWidth-- > 0) {
                    out.append(' ');
                }
            } else {
                out.format(this.getFormat(value), value);
            }
        }
    }

    private static class FixedColumn
    implements Column {
        private final String value;

        public FixedColumn(String value) {
            this.value = value;
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return 0;
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public int width(Object o) {
            return this.value.length();
        }

        @Override
        public void render(Object o, int actualWidth, PrintWriter out) {
            out.append(Strings.padEnd((String)this.value, (int)actualWidth, (char)' '));
        }
    }

    private class FixedScalingByteColumn
    extends AbstractByteColumn {
        private final ByteUnit units;
        private final String nullValue;

        public FixedScalingByteColumn(String name, ByteUnit units) {
            this(name, units, null);
        }

        public FixedScalingByteColumn(String name, ByteUnit units, String nullValue) {
            super(name);
            this.units = units;
            this.nullValue = nullValue;
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return Math.max(columnWidth - headerWidth, 0);
        }

        @Override
        public int width(Object rawValue) {
            if (rawValue == null) {
                if (this.nullValue != null) {
                    return this.nullValue.length();
                }
                return 0;
            }
            long value = (Long)rawValue;
            return this.renderValue(value, this.units).length();
        }

        @Override
        public void render(Object o, int actualWidth, PrintWriter out) {
            if (o == null) {
                if (this.nullValue == null) {
                    while (actualWidth-- > 0) {
                        out.append(' ');
                    }
                } else {
                    out.format("%" + actualWidth + "s", this.nullValue);
                }
            } else {
                String renderedValue = this.renderValue((Long)o, this.units);
                out.format("%" + actualWidth + "s", renderedValue);
            }
        }
    }

    private class HumanReadableByteColumn
    extends AbstractByteColumn {
        private final ByteUnit.Type displayUnits;
        private final String nullValue;

        public HumanReadableByteColumn(String name, ByteUnit.Type displayUnits) {
            this(name, displayUnits, null);
        }

        public HumanReadableByteColumn(String name, ByteUnit.Type displayUnits, String nullValue) {
            super(name);
            this.displayUnits = displayUnits;
            this.nullValue = nullValue;
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return Math.max(columnWidth - headerWidth, 0);
        }

        @Override
        public int width(Object rawValue) {
            if (rawValue == null) {
                if (this.nullValue != null) {
                    return this.nullValue.length();
                }
                return 0;
            }
            if (this.displayUnits.unitsOf((Long)rawValue) == ByteUnit.BYTES) {
                return 4;
            }
            return this.displayUnits == ByteUnit.Type.DECIMAL ? 5 : 6;
        }

        @Override
        public void render(Object o, int actualWidth, PrintWriter out) {
            if (o == null) {
                if (this.nullValue == null) {
                    while (actualWidth-- > 0) {
                        out.append(' ');
                    }
                } else {
                    int padding = actualWidth - this.nullValue.length();
                    while (padding-- > 0) {
                        out.append(' ');
                    }
                    out.append(this.nullValue);
                }
            } else {
                long value = (Long)o;
                ByteUnit units = this.displayUnits.unitsOf(value);
                String symbol = ByteUnits.isoSymbol().of(units);
                String numerical = this.renderValue(value, units);
                int padding = actualWidth - numerical.length() - symbol.length();
                while (padding-- > 0) {
                    out.append(' ');
                }
                out.append(numerical).append(symbol);
            }
        }
    }

    private abstract class AbstractByteColumn
    extends AbstractColumn {
        public AbstractByteColumn(String name) {
            super(name);
        }

        protected String renderValue(long value, ByteUnit units) {
            if (units == ByteUnit.BYTES) {
                return String.format("%3d", value);
            }
            double tmp = units.convert((double)value, ByteUnit.BYTES);
            if (tmp >= 0.0 && tmp < 9.95) {
                return String.format("%.1f", tmp);
            }
            return String.format("%.0f", tmp);
        }
    }

    private static class RightColumn
    extends RegularColumn {
        private RightColumn(String name) {
            super(name);
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return Math.max(columnWidth - headerWidth, 0);
        }

        @Override
        public void render(Object value, int actualWidth, PrintWriter out) {
            out.append(Strings.padStart((String)Objects.toString(value, ""), (int)actualWidth, (char)' '));
        }
    }

    private static class CentreColumn
    extends RegularColumn {
        private CentreColumn(String name) {
            super(name);
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return Math.max(columnWidth - headerWidth, 0) / 2;
        }

        @Override
        public void render(Object value, int actualWidth, PrintWriter out) {
            String text = Objects.toString(value, "");
            out.append(Strings.padEnd((String)Strings.padStart((String)text, (int)((actualWidth + text.length()) / 2), (char)' '), (int)actualWidth, (char)' '));
        }
    }

    private static class LeftColumn
    extends RegularColumn {
        private LeftColumn(String name) {
            super(name);
        }

        @Override
        public int headerIndentation(int headerWidth, int columnWidth) {
            return 0;
        }

        @Override
        public void render(Object value, int actualWidth, PrintWriter out) {
            out.append(Strings.padEnd((String)Objects.toString(value, ""), (int)actualWidth, (char)' '));
        }
    }

    private static abstract class RegularColumn
    extends AbstractColumn {
        private RegularColumn(String name) {
            super(name);
        }

        @Override
        public int width(Object value) {
            return Objects.toString(value, "").length();
        }
    }

    private static abstract class AbstractColumn
    implements Column {
        protected final String name;

        public AbstractColumn(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    private static interface Column {
        public String name();

        public int headerIndentation(int var1, int var2);

        public int width(Object var1);

        public void render(Object var1, int var2, PrintWriter var3);
    }

    public static enum DateStyle {
        ISO,
        LS;

    }
}

