/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> ListenableFuture<T> fromCompletableFuture(CompletableFuture<T> completable) {
        return new ListenableFutureImpl<T>(completable);
    }

    public static <T> CompletableFuture<T> fromListenableFuture(final ListenableFuture<T> listenable) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenable.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenable, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable t) {
                completable.completeExceptionally(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completable;
    }

    private static class ListenableFutureImpl<T>
    extends AbstractFuture<T>
    implements ListenableFuture<T>,
    BiConsumer<T, Throwable> {
        private final CompletableFuture<T> inner;

        public ListenableFutureImpl(CompletableFuture<T> inner) {
            this.inner = inner;
            inner.whenComplete((BiConsumer)this);
        }

        @Override
        public void accept(T value, Throwable throwable) {
            if (throwable != null) {
                if (throwable instanceof CancellationException) {
                    this.cancel(false);
                } else {
                    this.setException(throwable);
                }
            } else {
                this.set(value);
            }
        }
    }
}

