/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class FieldSort
implements Serializable {
    private static final long serialVersionUID = -9054869224739638232L;
    private String name;
    private boolean reverse;

    public FieldSort() {
    }

    public FieldSort(String name, boolean reverse) {
        this.name = name;
        this.reverse = reverse;
    }

    public FieldSort(String signPrefixedName) {
        if (signPrefixedName.startsWith("-")) {
            this.reverse = true;
            this.name = signPrefixedName.substring(1);
        } else {
            this.reverse = false;
            this.name = signPrefixedName;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public static <T extends Comparable<T>> Comparator<T> getSorter(List<FieldSort> sort, Function<FieldSort, Comparator<T>> next) {
        Comparator<T> comparator;
        if (sort == null || sort.isEmpty()) {
            comparator = Comparator.naturalOrder();
        } else {
            Iterator<FieldSort> it = sort.iterator();
            comparator = next.apply(it.next());
            while (it.hasNext()) {
                comparator = comparator.thenComparing(next.apply(it.next()));
            }
        }
        return comparator;
    }
}

