/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.dcache.util.GlobBraceParser;

public class Glob
implements Serializable {
    private static final long serialVersionUID = -5052804169005574207L;
    private static final CharMatcher WILDCARD = CharMatcher.anyOf((CharSequence)"*?{");
    public static final Glob ANY = new Glob("*");
    private final String _pattern;

    public Glob(String s) {
        this._pattern = s;
    }

    public boolean matches(String s) {
        return this.toPattern().matcher(s).matches();
    }

    public boolean isGlob() {
        return Glob.isGlob(this._pattern);
    }

    public String toString() {
        return this._pattern;
    }

    public Pattern toPattern() {
        return Glob.parseGlobToPattern(this._pattern);
    }

    public static Pattern parseGlobToPattern(String glob) {
        StringBuilder s = new StringBuilder(glob.length() * 2 + 2);
        int j = 0;
        s.append('^');
        block5: for (int i = 0; i < glob.length(); ++i) {
            switch (glob.charAt(i)) {
                case '?': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append('.');
                    j = i + 1;
                    continue block5;
                }
                case '*': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append(".*");
                    j = i + 1;
                    continue block5;
                }
                case '{': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    i = Glob.parseCurlyBrackets(glob, i, s);
                    j = i + 1;
                    continue block5;
                }
            }
        }
        s.append(Pattern.quote(glob.substring(j)));
        s.append('$');
        return Pattern.compile(s.toString());
    }

    private static int parseCurlyBrackets(String glob, int from, StringBuilder out) {
        int j;
        assert (glob.charAt(from) == '{');
        StringBuilder s = new StringBuilder();
        block7: for (int i = j = from + 1; i < glob.length(); ++i) {
            switch (glob.charAt(i)) {
                case '?': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append('.');
                    j = i + 1;
                    continue block7;
                }
                case '*': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append(".*");
                    j = i + 1;
                    continue block7;
                }
                case ',': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append('|');
                    j = i + 1;
                    continue block7;
                }
                case '{': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    i = Glob.parseCurlyBrackets(glob, i, s);
                    j = i + 1;
                    continue block7;
                }
                case '}': {
                    out.append('(').append((CharSequence)s).append(Pattern.quote(glob.substring(j, i))).append(')');
                    return i;
                }
            }
        }
        out.append(Pattern.quote("{"));
        return from;
    }

    public static boolean isGlob(String s) {
        return WILDCARD.matchesAnyOf((CharSequence)s);
    }

    public static Iterable<String> expandGlob(String glob) {
        return new GlobBraceParser(glob).expandGlob();
    }

    public static Iterable<String> expandList(String glob) {
        return new GlobBraceParser(glob).expandList();
    }
}

