/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

class GlobBraceParser {
    private final Scanner scanner;

    GlobBraceParser(String s) {
        this.scanner = new Scanner(s);
    }

    Iterable<String> expandGlob() {
        Iterable<String> result = this.expandE();
        this.checkEndOfInput();
        return result;
    }

    Iterable<String> expandList() {
        Iterable<String> result = this.expandS();
        this.checkEndOfInput();
        return result;
    }

    private void checkEndOfInput() {
        if (!this.scanner.peek().isEmpty()) {
            throw new IllegalArgumentException("Unexpected token " + this.scanner.peek());
        }
    }

    private Iterable<String> expandS() {
        return Iterables.concat(this.expandE(), this.expandT());
    }

    private Iterable<String> expandT() {
        switch (this.scanner.peek()) {
            case ",": {
                this.scanner.next();
                return this.expandS();
            }
        }
        return Collections.emptyList();
    }

    private Iterable<String> expandE() {
        switch (this.scanner.peek()) {
            case "{": 
            case "}": 
            case ",": {
                return this.expandF();
            }
        }
        return this.cartesianProduct(Collections.singletonList(this.scanner.next()), this.expandF());
    }

    private Iterable<String> expandF() {
        if (this.scanner.peek().equals("{")) {
            this.scanner.next();
            Iterable<String> left = this.expandS();
            String token = this.scanner.next();
            if (!token.equals("}")) {
                throw new IllegalArgumentException("Expected '}' instead of '" + token + "'");
            }
            Iterable<String> right = this.expandE();
            return this.cartesianProduct(left, right);
        }
        return Collections.singletonList("");
    }

    private Iterable<String> cartesianProduct(Iterable<String> left, Iterable<String> right) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s1 : left) {
            for (String s2 : right) {
                result.add(s1 + s2);
            }
        }
        return result;
    }

    private static class Scanner {
        private final StringTokenizer tokenizer;
        private String current;

        public Scanner(String s) {
            this.tokenizer = new StringTokenizer(s, ",{}", true);
            this.current = this.tokenizer.hasMoreTokens() ? this.tokenizer.nextToken() : "";
        }

        public String peek() {
            return this.current;
        }

        public String next() {
            String current = this.current;
            this.current = this.tokenizer.hasMoreTokens() ? this.tokenizer.nextToken() : "";
            return current;
        }
    }
}

