/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.PrintWriter;
import java.io.Writer;

public class LineIndentingPrintWriter
extends PrintWriter {
    private final String prefix;
    private boolean isLineStart = true;

    public LineIndentingPrintWriter(Writer inner, String prefix) {
        super(inner);
        this.prefix = prefix;
    }

    @Override
    public void println() {
        super.println();
        this.isLineStart = true;
    }

    @Override
    public void write(int c) {
        if (c == 10) {
            this.isLineStart = true;
        } else if (this.isLineStart) {
            this.isLineStart = false;
            super.write(this.prefix);
        }
        super.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        int curr = off;
        int index = this.indexOf(cbuf, '\n', curr);
        while (index != -1 && index <= off + len) {
            if (this.isLineStart) {
                this.isLineStart = false;
                super.write(this.prefix, 0, this.prefix.length());
            }
            int count = 1 + index - curr;
            super.write(cbuf, curr, count);
            curr = index + 1;
            index = this.indexOf(cbuf, '\n', curr);
            this.isLineStart = true;
        }
        if (curr < off + len) {
            if (this.isLineStart) {
                this.isLineStart = false;
                super.write(this.prefix, 0, this.prefix.length());
            }
            super.write(cbuf, curr, off + len - curr);
        }
    }

    private int indexOf(char[] buf, char c, int off) {
        for (int i = off; i < buf.length; ++i) {
            if (buf[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        int curr = off;
        int index = str.indexOf(10, curr);
        while (index != -1 && index <= off + len) {
            if (this.isLineStart) {
                this.isLineStart = false;
                super.write(this.prefix, 0, this.prefix.length());
            }
            int count = 1 + index - curr;
            super.write(str, curr, count);
            curr = index + 1;
            index = str.indexOf(10, curr);
            this.isLineStart = true;
        }
        if (curr < off + len) {
            if (this.isLineStart) {
                this.isLineStart = false;
                super.write(this.prefix, 0, this.prefix.length());
            }
            super.write(str, curr, off + len - curr);
        }
    }
}

