/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.net.InetAddresses;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.dcache.util.NDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetworkUtils.class);
    public static final String LOCAL_HOST_ADDRESS_PROPERTY = "org.dcache.net.localaddresses";
    private static String canonicalHostName;
    private static final int RANDOM_PORT = 23241;
    private static final List<InetAddress> FAKED_ADDRESSES;
    private static final com.google.common.base.Supplier<List<InetAddress>> LOCAL_ADDRESS_SUPPLIER;

    public static synchronized String getCanonicalHostName() {
        if (canonicalHostName == null) {
            canonicalHostName = NetworkUtils.getPreferredHostName();
        }
        return canonicalHostName;
    }

    public static Collection<InetAddress> getLocalAddresses() {
        if (!FAKED_ADDRESSES.isEmpty()) {
            return FAKED_ADDRESSES;
        }
        return Collections2.filter((Collection)((Collection)LOCAL_ADDRESS_SUPPLIER.get()), NetworkUtils.isNotMulticast());
    }

    public static URL toURL(URI uri) throws URISyntaxException {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            URISyntaxException exception = new URISyntaxException(uri.toString(), e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public static InetAddress getLocalAddress(InetAddress expectedSource) throws SocketException {
        InetAddress localAddress = NetworkUtils.getLocalAddress(expectedSource, NetworkUtils.getProtocolFamily(expectedSource));
        if (localAddress == null) {
            if (!FAKED_ADDRESSES.isEmpty()) {
                localAddress = FAKED_ADDRESSES.get(0);
            } else {
                try (DatagramSocket socket = new DatagramSocket();){
                    socket.connect(expectedSource, 23241);
                    localAddress = socket.getLocalAddress();
                    if (localAddress.isAnyLocalAddress()) {
                        InetAddressScope minScope = InetAddressScope.of(expectedSource);
                        try {
                            InetAddress inetAddress = (InetAddress)Ordering.natural().onResultOf(InetAddressScope::of).min(Iterables.filter((Iterable)((Iterable)LOCAL_ADDRESS_SUPPLIER.get()), (Predicate)Predicates.and(NetworkUtils.greaterThanOrEquals(minScope), NetworkUtils.isNotMulticast())));
                            return inetAddress;
                        }
                        catch (NoSuchElementException e) {
                            throw new SocketException("Unable to find address that faces " + expectedSource);
                        }
                    }
                }
            }
        }
        return localAddress;
    }

    /*
     * Exception decompiling
     */
    public static InetAddress getLocalAddress(InetAddress expectedSource, ProtocolFamily protocolFamily) throws SocketException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Predicate<InetAddress> isNotMulticast() {
        return address -> !address.isMulticastAddress();
    }

    private static Predicate<InetAddress> hasProtocolFamily(ProtocolFamily protocolFamily) {
        return address -> NetworkUtils.getProtocolFamily(address) == protocolFamily;
    }

    private static Predicate<InetAddress> greaterThanOrEquals(InetAddressScope scope) {
        return address -> InetAddressScope.of(address).ordinal() >= scope.ordinal();
    }

    public static ProtocolFamily getProtocolFamily(InetAddress address) {
        if (address instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (address instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalArgumentException("Unknown protocol family: " + address);
    }

    public static String toString(InetAddress a) {
        String name = a.getHostName();
        if (InetAddresses.isInetAddress((String)name)) {
            return InetAddresses.toAddrString((InetAddress)a);
        }
        return name + "/" + InetAddresses.toUriString((InetAddress)a);
    }

    private static String getPreferredHostName() {
        List addresses = Ordering.natural().onResultOf(InetAddressScope::of).reverse().sortedCopy(NetworkUtils.getLocalAddresses());
        if (addresses.isEmpty()) {
            return "localhost";
        }
        for (InetAddress a : addresses) {
            String hostName = NetworkUtils.stripScope(a.getCanonicalHostName());
            if (InetAddresses.isInetAddress((String)hostName)) continue;
            return hostName;
        }
        return ((InetAddress)addresses.get(0)).getCanonicalHostName();
    }

    private static String stripScope(String hostName) {
        int i = hostName.indexOf(37);
        if (i > 0) {
            return hostName.substring(0, i);
        }
        return hostName;
    }

    public static boolean isInetAddress(String hostname) {
        return InetAddresses.isInetAddress((String)NetworkUtils.stripScope(hostname));
    }

    public static InetAddress withCanonicalAddress(InetAddress address) {
        try {
            String name = address.getCanonicalHostName();
            if (address instanceof Inet6Address) {
                name = NetworkUtils.stripScope(name);
            }
            return InetAddress.getByAddress(name, address.getAddress());
        }
        catch (UnknownHostException e) {
            return address;
        }
    }

    public static Supplier<List<InetAddress>> anyAddressSupplier() {
        return new AnyAddressSupplier();
    }

    public static Supplier<List<InetAddress>> hostListAddressSupplier(String list) throws UnknownHostException {
        return new HostListAddressSupplier(list);
    }

    static {
        LOCAL_ADDRESS_SUPPLIER = Suppliers.memoizeWithExpiration((com.google.common.base.Supplier)new LocalAddressSupplier(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        String value = Strings.nullToEmpty((String)System.getProperty(LOCAL_HOST_ADDRESS_PROPERTY));
        ImmutableList.Builder fakedAddresses = ImmutableList.builder();
        for (String address : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            try {
                fakedAddresses.add((Object)InetAddress.getByName(address));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Can't resolve fake hostname " + address + " provided by org.dcache.net.localaddresses", e);
            }
        }
        FAKED_ADDRESSES = fakedAddresses.build();
    }

    private static class LocalAddressSupplier
    implements com.google.common.base.Supplier<List<InetAddress>> {
        private LocalAddressSupplier() {
        }

        public List<InetAddress> get() {
            try {
                return Lists.newArrayList((Iterator)Iterators.transform((Iterator)Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), i -> {
                    try {
                        if (i.isUp()) {
                            return Iterators.forEnumeration(i.getInetAddresses());
                        }
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    return Collections.emptyIterator();
                })), input -> {
                    try {
                        return InetAddress.getByAddress(input.getAddress());
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException("Failed to create new instance of InetAddress", e);
                    }
                }));
            }
            catch (SocketException e) {
                logger.error("Failed to resolve local network addresses: {}", (Object)e.toString());
                return Collections.emptyList();
            }
        }
    }

    public static enum InetAddressScope {
        LOOPBACK,
        LINK,
        SITE,
        GLOBAL;


        public static InetAddressScope of(InetAddress address) {
            if (address.isLoopbackAddress()) {
                return LOOPBACK;
            }
            if (address.isLinkLocalAddress()) {
                return LINK;
            }
            if (address.isSiteLocalAddress()) {
                return SITE;
            }
            return GLOBAL;
        }
    }

    public static class AnyAddressSupplier
    implements Supplier<List<InetAddress>> {
        private List<InetAddress> _previous = Collections.emptyList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<InetAddress> get() {
            NDC.push("NIC auto-discovery");
            try {
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
                Stopwatch stopwatch = Stopwatch.createStarted();
                try {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface i = interfaces.nextElement();
                        try {
                            if (!i.isUp() || i.isLoopback()) continue;
                            Enumeration<InetAddress> e = i.getInetAddresses();
                            while (e.hasMoreElements()) {
                                addresses.add(NetworkUtils.withCanonicalAddress(e.nextElement()));
                            }
                        }
                        catch (SocketException e) {
                            logger.warn("Not publishing NIC {}: {}", (Object)i.getName(), (Object)e.getMessage());
                        }
                    }
                }
                catch (SocketException e) {
                    logger.warn("Not publishing NICs: {}", (Object)e.getMessage());
                }
                logger.debug("Scan took {}", (Object)stopwatch);
                this.logChanges(addresses);
                ArrayList<InetAddress> arrayList = addresses;
                return arrayList;
            }
            finally {
                NDC.pop();
            }
        }

        private synchronized void logChanges(List<InetAddress> addresses) {
            if (!this._previous.equals(addresses)) {
                boolean removing;
                List<InetAddress> added = addresses.stream().filter(a -> !this._previous.contains(a)).collect(Collectors.toList());
                List<InetAddress> removed = this._previous.stream().filter(a -> !addresses.contains(a)).collect(Collectors.toList());
                boolean adding = !added.isEmpty();
                boolean bl = removing = !removed.isEmpty();
                if (removing || adding) {
                    StringBuilder sb = new StringBuilder();
                    if (removing) {
                        sb.append("Removing ").append(AnyAddressSupplier.describeList(removed));
                    }
                    if (adding) {
                        if (removing) {
                            sb.append(", adding ");
                        } else {
                            sb.append("Adding ");
                        }
                        sb.append(AnyAddressSupplier.describeList(added));
                    }
                    logger.warn(sb.toString());
                }
                this._previous = new ArrayList<InetAddress>(addresses);
            }
        }

        private static String describeList(List<InetAddress> addresses) {
            if (addresses.size() == 1) {
                return addresses.get(0).toString();
            }
            return addresses.stream().map(NetworkUtils::toString).collect(Collectors.joining(", ", "[", "]"));
        }
    }

    private static class HostListAddressSupplier
    implements Supplier<List<InetAddress>> {
        private final List<InetAddress> fixedAddresses;
        private final Supplier<List<InetAddress>> dynamicAddresses;

        public HostListAddressSupplier(@Nullable String hosts) throws UnknownHostException {
            boolean wildcard = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String host : Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)hosts)) {
                if (NetworkUtils.isInetAddress(host)) {
                    InetAddress address = InetAddresses.forString((String)host);
                    Preconditions.checkArgument((!address.isMulticastAddress() ? 1 : 0) != 0, (String)"Invalid address %s: cannot publish a multicast address", (Object)host);
                    if (address.isAnyLocalAddress()) {
                        wildcard = true;
                        continue;
                    }
                    builder.add((Object)NetworkUtils.withCanonicalAddress(address));
                    continue;
                }
                builder.add((Object)InetAddress.getByName(host));
            }
            this.dynamicAddresses = wildcard ? new AnyAddressSupplier() : () -> Collections.emptyList();
            this.fixedAddresses = builder.build();
        }

        @Override
        public List<InetAddress> get() {
            List<InetAddress> dynamic = this.dynamicAddresses.get();
            if (dynamic.isEmpty()) {
                return this.fixedAddresses;
            }
            if (this.fixedAddresses.isEmpty()) {
                return dynamic;
            }
            ArrayList<InetAddress> combined = new ArrayList<InetAddress>();
            combined.addAll(dynamic);
            combined.addAll(this.fixedAddresses);
            return combined;
        }
    }
}

