/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import java.io.PrintWriter;
import java.io.Writer;

public class NoTrailingWhitespacePrintWriter
extends PrintWriter {
    private StringBuilder padding;

    public NoTrailingWhitespacePrintWriter(Writer inner) {
        super(inner);
    }

    private StringBuilder getPadding() {
        if (this.padding == null) {
            this.padding = new StringBuilder();
        }
        return this.padding;
    }

    private void flushPadding() {
        if (this.padding != null) {
            String pad = this.padding.toString();
            super.write(pad, 0, pad.length());
            this.padding = null;
        }
    }

    private int lastTrailingWhitespace(char[] buf, int off, int len) {
        int idx = -1;
        int i = off + len - 1;
        while (i >= off && CharMatcher.whitespace().matches(buf[i])) {
            idx = i--;
        }
        return idx;
    }

    private int lastTrailingWhitespace(String s, int off, int len) {
        int idx = -1;
        int i = off + len - 1;
        while (i >= off && CharMatcher.whitespace().matches(s.charAt(i))) {
            idx = i--;
        }
        return idx;
    }

    @Override
    public void println() {
        super.println();
        this.padding = null;
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int c) {
        if (CharMatcher.whitespace().matches((char)c)) {
            this.getPadding().append((char)c);
        } else {
            this.flushPadding();
            super.write(c);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        int idx = this.lastTrailingWhitespace(buf, off, len);
        if (idx != 0) {
            this.flushPadding();
            super.write(buf, off, idx == -1 ? len : idx - off);
        }
        if (idx > -1) {
            this.getPadding().append(buf, idx, len - (idx - off));
        }
    }

    @Override
    public void write(String s, int off, int len) {
        int idx = this.lastTrailingWhitespace(s, off, len);
        if (idx != 0) {
            this.flushPadding();
            super.write(s, off, idx == -1 ? len : idx - off);
        }
        if (idx > -1) {
            this.getPadding().append(s, idx, off + len);
        }
    }
}

