/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortRange {
    protected static final Pattern FORMAT = Pattern.compile("(\\d+)(?:(?:,|:)(\\d+))?");
    private static final Random _random = new Random();
    public static final PortRange ANY = new PortRange(0, 0);
    protected final int _lower;
    protected final int _upper;

    public PortRange(int low, int high) {
        this._lower = low == 0 && high > 0 ? 1 : low;
        this._upper = high;
        if (low < 0 || high < low || 65535 < high) {
            throw new IllegalArgumentException("Invalid range");
        }
    }

    public PortRange(int port) {
        this(port, port);
    }

    public static PortRange valueOf(String s) throws IllegalArgumentException {
        try {
            Matcher m = FORMAT.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid range: " + s);
            }
            String lowString = m.group(1);
            String highString = m.group(2);
            int low = Integer.parseInt(lowString);
            int high = highString == null ? low : Integer.parseInt(highString);
            return new PortRange(low, high);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range: " + s);
        }
    }

    public static PortRange getGlobusTcpPortRange() {
        String value = System.getenv("GLOBUS_TCP_PORT_RANGE");
        if (value != null) {
            return PortRange.valueOf(value);
        }
        value = System.getProperty("org.globus.tcp.port.range");
        if (value != null) {
            return PortRange.valueOf(value);
        }
        return new PortRange(0);
    }

    public int getLower() {
        return this._lower;
    }

    public int getUpper() {
        return this._upper;
    }

    public int random() {
        return _random.nextInt(this._upper - this._lower + 1) + this._lower;
    }

    public int succ(int port) {
        return port < this._upper ? port + 1 : this._lower;
    }

    public int bind(ServerSocket socket, InetSocketAddress endpoint) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        return range.bind(socket, endpoint.getAddress(), 0);
    }

    public int bind(Socket socket, InetSocketAddress endpoint) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        return range.bind(socket, endpoint.getAddress());
    }

    public int bind(ServerSocket socket, InetAddress address) throws IOException {
        return this.bind(socket, address, 0);
    }

    public int bind(ServerSocket socket, InetAddress address, int backlog) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port), backlog);
                return port;
            }
            catch (BindException bindException) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public int bind(Socket socket, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port));
                return port;
            }
            catch (BindException bindException) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public int bind(ServerSocket socket) throws IOException {
        return this.bind(socket, (InetAddress)null);
    }

    public int bind(ServerSocket socket, int backlog) throws IOException {
        return this.bind(socket, null, backlog);
    }

    public int bind(Socket socket) throws IOException {
        return this.bind(socket, (InetAddress)null);
    }

    public String toString() {
        return String.format("%d:%d", this._lower, this._upper);
    }
}

