/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.DesiredRole;
import org.dcache.auth.EmailAddressPrincipal;
import org.dcache.auth.ExemptFromNamespaceChecks;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.OidcSubjectPrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;

public class PrincipalSetMaker {
    private final Set<Principal> _principals = Sets.newHashSet();
    private final Set<Principal> _unmodifiableView = Collections.unmodifiableSet(this._principals);

    public static PrincipalSetMaker aSetOfPrincipals() {
        return new PrincipalSetMaker();
    }

    public PrincipalSetMaker withUid(int uid) {
        this._principals.add(new UidPrincipal(uid));
        return this;
    }

    public PrincipalSetMaker withUsername(String username) {
        this._principals.add(new UserNamePrincipal(username));
        return this;
    }

    public PrincipalSetMaker withPrimaryGroupname(String name) {
        this._principals.add(new GroupNamePrincipal(name, true));
        return this;
    }

    public PrincipalSetMaker withGroupname(String name) {
        this._principals.add(new GroupNamePrincipal(name));
        return this;
    }

    public PrincipalSetMaker withPrimaryGid(int gid) {
        this._principals.add(new GidPrincipal(gid, true));
        return this;
    }

    public PrincipalSetMaker withGid(int gid) {
        this._principals.add(new GidPrincipal(gid, false));
        return this;
    }

    public PrincipalSetMaker withDn(String dn) {
        this._principals.add(new GlobusPrincipal(dn));
        return this;
    }

    public PrincipalSetMaker withPrimaryFqan(String fqan) {
        this._principals.add(new FQANPrincipal(fqan, true));
        return this;
    }

    public PrincipalSetMaker withFqan(String name) {
        this._principals.add(new FQANPrincipal(name));
        return this;
    }

    public PrincipalSetMaker withDesiredRole(String name) {
        this._principals.add(new DesiredRole(name));
        return this;
    }

    public PrincipalSetMaker withOidc(String sub, String op) {
        this._principals.add(new OidcSubjectPrincipal(sub, op));
        return this;
    }

    public PrincipalSetMaker withEmail(String address) {
        this._principals.add(new EmailAddressPrincipal(address));
        return this;
    }

    public PrincipalSetMaker withKerberos(String kerberos) {
        this._principals.add(new KerberosPrincipal(kerberos));
        return this;
    }

    public PrincipalSetMaker withExemptFromNamespaceChecks() {
        this._principals.add(new ExemptFromNamespaceChecks());
        return this;
    }

    public Set<Principal> build() {
        return this._unmodifiableView;
    }
}

