/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.net.InetAddresses;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.dcache.util.ByteUnit;
import org.dcache.util.ByteUnits;
import org.dcache.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Strings.class);
    private static final String ANSI_ESCAPE = "\u001b[";
    private static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final String INFINITY = "infinity";
    private static final DecimalFormat THREE_SIG_FIG_FORMAT = new DecimalFormat("0.##E0");

    public static String[] splitArgumentString(String argumentString) {
        LOGGER.debug("splitting argument string {}", (Object)argumentString);
        if (argumentString == null) {
            return ZERO_LENGTH_STRING_ARRAY;
        }
        argumentString = argumentString.trim();
        Pattern regex = Pattern.compile("\"([^\"]*)\"|'([^']*)'|([^\\s]+)");
        Matcher regexMatcher = regex.matcher(argumentString);
        ArrayList<String> matchList = new ArrayList<String>();
        while (regexMatcher.find()) {
            String groupMatch;
            if (regexMatcher.group(1) != null) {
                groupMatch = regexMatcher.group(1);
                LOGGER.debug("first group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                groupMatch = regexMatcher.group(2);
                LOGGER.debug("second group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(3) == null) continue;
            groupMatch = regexMatcher.group(3);
            LOGGER.debug("third group matched [{}]", (Object)groupMatch);
            matchList.add(groupMatch);
        }
        return (String[])matchList.toArray(String[]::new);
    }

    public static int plainLength(String s) {
        int length;
        int plainLength = length = s.length();
        int i = s.indexOf(ANSI_ESCAPE);
        while (i > -1) {
            plainLength -= ANSI_ESCAPE.length();
            if ((i += ANSI_ESCAPE.length()) < length) {
                while (i + 1 < length && (s.charAt(i) < '@' || s.charAt(i) > '~')) {
                    ++i;
                    --plainLength;
                }
                ++i;
                --plainLength;
            }
            i = s.indexOf(ANSI_ESCAPE, i);
        }
        return plainLength;
    }

    private static int indexOfNextWrap(char[] chars, int fromIndex, int wrapLength) {
        int lastWrap = -1;
        int max = fromIndex + wrapLength;
        int length = chars.length;
        for (int i = fromIndex; i < length && (i <= max || lastWrap == -1); ++i) {
            if (Character.isWhitespace(chars[i])) {
                lastWrap = i;
                continue;
            }
            if (chars[i] != '\u001b' || i >= length || chars[i + 1] != '[') continue;
            i += 2;
            max += 2;
            while (i < length && (chars[i] < '@' || chars[i] > '~')) {
                ++max;
                ++i;
            }
            ++max;
        }
        return length <= max || lastWrap == -1 ? length : lastWrap;
    }

    public static String wrap(String indent, String str, int wrapLength) {
        int offset = 0;
        StringBuilder out = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        int length = chars.length;
        while (offset < length) {
            int spaceToWrapAt;
            int eop;
            int bop = offset;
            while (offset < length && chars[offset] == ' ') {
                ++offset;
            }
            int pil = offset - bop;
            for (eop = offset; eop < length && chars[eop] != '\n'; ++eop) {
            }
            while ((spaceToWrapAt = Strings.indexOfNextWrap(chars, offset, wrapLength - indent.length() - pil)) < eop) {
                out.append(indent);
                out.append(chars, bop, pil);
                out.append(chars, offset, spaceToWrapAt - offset);
                out.append('\n');
                for (offset = spaceToWrapAt + 1; offset < length && chars[offset] == ' '; ++offset) {
                }
            }
            out.append(indent).append(chars, bop, pil).append(chars, offset, eop - offset).append('\n');
            offset = eop + 1;
        }
        return out.toString();
    }

    public static String toStringSignature(Method m, Character c) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append('(');
        Joiner.on((char)c.charValue()).appendTo(sb, Iterables.transform(Arrays.asList(m.getParameterTypes()), Class::getSimpleName));
        sb.append(')');
        return sb.toString();
    }

    public static int parseInt(String s) throws NumberFormatException {
        return s.equals(INFINITY) ? Integer.MAX_VALUE : Integer.parseInt(s);
    }

    public static long parseLong(String s) throws NumberFormatException {
        return s.equals(INFINITY) ? Long.MAX_VALUE : Long.parseLong(s);
    }

    public static long parseTime(String s, TimeUnit unit) {
        return s.equals(INFINITY) ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.convert(Long.parseLong(s), unit);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])value);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])value);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])value);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])value);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])value);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])value);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public static String toMultilineString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])value);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])value);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])value);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])value);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])value);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])value);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])value);
            }
            return Joiner.on((char)'\n').join(Iterables.transform(Arrays.asList((Object[])value), Strings::toString));
        }
        return value.toString();
    }

    public static Optional<String> combine(Optional<String> first, String seperator, Optional<String> second) {
        if (first.isPresent()) {
            if (second.isPresent()) {
                return Optional.of(first.get() + seperator + second.get());
            }
            return first;
        }
        return second;
    }

    public static String indentLines(String indent, String text) {
        return new BufferedReader(new StringReader(text)).lines().map(s -> indent + s).collect(Collectors.joining("\n"));
    }

    public static boolean isInBrackets(String target) {
        return target.startsWith("(") && target.endsWith(")") || target.startsWith("[") && target.endsWith("]") || target.startsWith("<") && target.endsWith(">") || target.startsWith("{") && target.endsWith("}");
    }

    public static String describeBandwidth(StatisticalSummary bandwidth) {
        Object meanDescription;
        double min = bandwidth.getMin();
        double max = bandwidth.getMax();
        double sd = bandwidth.getStandardDeviation();
        if (min == max) {
            return Strings.describeBandwidth(max);
        }
        double mean = bandwidth.getMean();
        double sem = bandwidth.getStandardDeviation() / Math.sqrt(bandwidth.getN());
        if (sem == 0.0) {
            meanDescription = Strings.describeBandwidth(mean);
        } else {
            ByteUnit units = ByteUnit.Type.BINARY.unitsOf(mean);
            double scaledMean = units.convert(mean, ByteUnit.BYTES);
            double scaledSem = units.convert(sem, ByteUnit.BYTES);
            meanDescription = "(" + Strings.toThreeSigFig(scaledMean, 1024.0, scaledSem) + ") " + ByteUnits.isoSymbol().of(units) + "/s";
        }
        return "min. " + Strings.describeBandwidth(min) + ", mean " + (String)meanDescription + ", SD " + Strings.describeBandwidth(sd) + ", max. " + Strings.describeBandwidth(max);
    }

    public static String describeSize(StatisticalSummary size) {
        Object meanDescription;
        long max;
        long min = Math.round(size.getMin());
        if (min == (max = Math.round(size.getMax()))) {
            return Strings.describeSize(max);
        }
        double mean = size.getMean();
        double sem = size.getStandardDeviation() / Math.sqrt(size.getN());
        if (sem == 0.0) {
            meanDescription = Strings.describeSize(Math.round(mean));
        } else {
            ByteUnit units = ByteUnit.Type.BINARY.unitsOf(mean);
            double scaledMean = units.convert(mean, ByteUnit.BYTES);
            double scaledSem = units.convert(sem, ByteUnit.BYTES);
            meanDescription = "(" + Strings.toThreeSigFig(scaledMean, 1024.0, scaledSem) + ") " + ByteUnits.isoSymbol().of(units);
        }
        long sd = Math.round(size.getStandardDeviation());
        return "min. " + Strings.describeSize(min) + ", mean " + (String)meanDescription + ", SD " + Strings.describeSize(sd) + ", max. " + Strings.describeSize(max);
    }

    public static String describeInteger(StatisticalSummary statistics) {
        long max;
        long min = Math.round(statistics.getMin());
        if (min == (max = Math.round(statistics.getMax()))) {
            return String.valueOf(max);
        }
        double mean = statistics.getMean();
        double sd = statistics.getStandardDeviation();
        double sem = sd / Math.sqrt(statistics.getN());
        Object meanDescription = sem == 0.0 ? String.valueOf(Math.round(mean)) : "(" + Strings.toThreeSigFig(mean, 1000.0, sem) + ")";
        return " min. " + min + ", mean " + (String)meanDescription + ", SD " + Strings.toThreeSigFig(sd, 1000.0) + ", max. " + max;
    }

    public static String humanReadableSize(long size) {
        ByteUnit units = ByteUnit.Type.BINARY.unitsOf(size);
        return Strings.toThreeSigFig(units.convert((double)size, ByteUnit.BYTES), 1024.0) + " " + ByteUnits.isoSymbol().of(units);
    }

    public static String describeSize(long size) {
        StringBuilder sb = new StringBuilder();
        sb.append(size).append(' ').append(ByteUnits.isoSymbol().of(ByteUnit.BYTES));
        ByteUnit units = ByteUnit.Type.BINARY.unitsOf(size);
        if (units != ByteUnit.BYTES) {
            sb.append(" (").append(Strings.toThreeSigFig(units.convert((double)size, ByteUnit.BYTES), 1024.0)).append(' ').append(ByteUnits.isoSymbol().of(units)).append(')');
        }
        return sb.toString();
    }

    public static String describeBandwidth(double value) {
        ByteUnit units = ByteUnit.Type.BINARY.unitsOf(value);
        return Strings.toThreeSigFig(units.convert(value, ByteUnit.BYTES), 1024.0) + " " + ByteUnits.isoSymbol().of(units) + "/s";
    }

    public static String toThreeSigFig(double value, double max) {
        if (value == 0.0) {
            return "0";
        }
        if (value < 0.0) {
            if (value <= -1.0) {
                if (value > -10.0) {
                    return String.format("%.2f", value);
                }
                if (value > -100.0) {
                    return String.format("%.1f", value);
                }
                if (Math.abs(value) < max) {
                    return String.format("%.0f", value);
                }
            }
        } else if (value >= 1.0) {
            if (value < 10.0) {
                return String.format("%.2f", value);
            }
            if (value < 100.0) {
                return String.format("%.1f", value);
            }
            if (value < max) {
                return String.format("%.0f", value);
            }
        }
        return THREE_SIG_FIG_FORMAT.format(value);
    }

    public static String toThreeSigFig(double value, double max, double uncertainty) {
        if (uncertainty == 0.0) {
            return Strings.toThreeSigFig(value, max);
        }
        if (value == 0.0) {
            return "0 \u00b1 " + Strings.toThreeSigFig(uncertainty, max);
        }
        if (value >= 1.0) {
            if (value < 10.0) {
                return String.format("%.2f", value) + " \u00b1 " + String.format("%.2f", uncertainty);
            }
            if (value < 100.0) {
                return String.format("%.1f", value) + " \u00b1 " + String.format("%.1f", uncertainty);
            }
            if (value < max) {
                return String.format("%.0f", value) + " \u00b1 " + String.format("%.0f", uncertainty);
            }
        }
        return THREE_SIG_FIG_FORMAT.format(value) + " \u00b1 " + THREE_SIG_FIG_FORMAT.format(uncertainty);
    }

    public static String describe(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            return InetAddresses.toUriString((InetAddress)inet.getAddress()) + ":" + inet.getPort();
        }
        return address.toString();
    }

    public static CharSequence describe(Optional<Instant> when) {
        return when.map(TimeUtils::relativeTimestamp).orElse("never");
    }

    public static String base64Hash(String in) {
        byte[] hashBytes = new byte[8];
        Hashing.sha256().hashBytes(in.getBytes(StandardCharsets.UTF_8)).writeBytesTo(hashBytes, 0, hashBytes.length);
        return Base64.getEncoder().withoutPadding().encodeToString(hashBytes);
    }

    static {
        DecimalFormatSymbols symbols = THREE_SIG_FIG_FORMAT.getDecimalFormatSymbols();
        symbols.setExponentSeparator("x10^");
        symbols.setNaN("-");
        THREE_SIG_FIG_FORMAT.setDecimalFormatSymbols(symbols);
    }
}

