/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.dcache.util.IPMatcher;

public class Subnet
implements Serializable {
    private static final long serialVersionUID = 9210530422244320383L;
    private static final Pattern MAPPED_ADDRESS = Pattern.compile("(0{1,4}:){0,12}:?:ffff(((.[0-9]{1,3}){4})|(:([0-9a-fA-F]{1,4})){2})");
    private static final Pattern DOCUMENTATION_ADDRESS = Pattern.compile("2001:0?db8:[0-9a-fA-F:]*");
    private static final Pattern TOREDO_ADDRESS = Pattern.compile("2001:0{0,4}:[0-9a-fA-F:]*");
    private static final String ALL_SUBNET = "all";
    private final InetAddress _subnetAddress;
    private final int _mask;

    protected Subnet() {
        this._subnetAddress = null;
        this._mask = 0;
    }

    protected Subnet(InetAddress subnetAddress, int mask) {
        InetAddress address;
        int hostBits = (subnetAddress instanceof Inet4Address ? 32 : 128) - mask;
        BigInteger maskedAddress = new BigInteger(subnetAddress.getAddress()).shiftRight(hostBits).shiftLeft(hostBits);
        try {
            address = InetAddress.getByAddress(maskedAddress.toByteArray());
        }
        catch (UnknownHostException uhe) {
            address = subnetAddress;
        }
        this._subnetAddress = address;
        this._mask = mask;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Subnet)) {
            return false;
        }
        return other.toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this._subnetAddress != null ? this._subnetAddress.hashCode() : 0);
        hash = 53 * hash + this._mask;
        return hash;
    }

    public InetAddress getSubnetAddress() {
        return this._subnetAddress;
    }

    public int getMask() {
        return this._mask;
    }

    public static Subnet create(InetAddress subnetAddress, int mask) {
        return new Subnet(subnetAddress, mask);
    }

    public static boolean isValid(String netmaskPattern) {
        String[] parts = netmaskPattern.split("/");
        if (!InetAddresses.isInetAddress((String)parts[0])) {
            return false;
        }
        InetAddress originalAddress = InetAddresses.forString((String)parts[0]);
        String originalHostAddress = originalAddress.getHostAddress();
        if (DOCUMENTATION_ADDRESS.matcher(originalHostAddress).matches() || TOREDO_ADDRESS.matcher(originalHostAddress).matches()) {
            return false;
        }
        if (parts.length > 1) {
            boolean isIpV6Mask;
            InetAddress subnetAddress = IPMatcher.tryConvertToIPv4(originalAddress);
            int maskBitLength = subnetAddress instanceof Inet4Address ? 32 : 128;
            int cidrMask = IPMatcher.convertToCidrIfIsIPv4Mask(parts[1]);
            boolean bl = isIpV6Mask = MAPPED_ADDRESS.matcher(parts[0]).matches() || originalAddress instanceof Inet6Address;
            if (isIpV6Mask && maskBitLength == 32) {
                cidrMask = cidrMask == 128 ? 32 : cidrMask & 0x1F;
            }
            return cidrMask <= maskBitLength;
        }
        return true;
    }

    public static Subnet create(String netmaskPattern) {
        int maskBitLength;
        String originalHostAddress;
        String[] netmaskParts = netmaskPattern.split("/");
        String hostname = netmaskParts[0];
        InetAddress originalAddress = InetAddresses.forString((String)hostname);
        boolean isIpV6Mask = originalAddress instanceof Inet6Address;
        if (MAPPED_ADDRESS.matcher(hostname).matches()) {
            isIpV6Mask = true;
        }
        Preconditions.checkArgument((!DOCUMENTATION_ADDRESS.matcher(originalHostAddress = originalAddress.getHostAddress()).matches() ? 1 : 0) != 0, (String)"Special documentation address '%s' cannot be used to create a Subnet", (Object)hostname);
        Preconditions.checkArgument((!TOREDO_ADDRESS.matcher(originalHostAddress).matches() ? 1 : 0) != 0, (String)"Toredo address '%s' cannot be used to create a Subnet", (Object)hostname);
        InetAddress subnetAddress = IPMatcher.tryConvertToIPv4(originalAddress);
        int n = maskBitLength = subnetAddress instanceof Inet4Address ? 32 : 128;
        if (netmaskParts.length > 1) {
            String maskbits = netmaskParts[1];
            int cidrMask = IPMatcher.convertToCidrIfIsIPv4Mask(maskbits);
            if (isIpV6Mask && maskBitLength == 32) {
                cidrMask = cidrMask == 128 ? 32 : cidrMask & 0x1F;
            }
            Preconditions.checkArgument((cidrMask <= maskBitLength ? 1 : 0) != 0, (String)"Network mask '%s' in netmask pattern '%s' is too big for IP address '%s'", (Object)cidrMask, (Object)netmaskPattern, (Object)originalAddress);
            return Subnet.create(subnetAddress, cidrMask);
        }
        return Subnet.create(subnetAddress, maskBitLength);
    }

    public static Subnet create() {
        return new Subnet(){
            private static final long serialVersionUID = 97750694361406752L;

            @Override
            public boolean contains(InetAddress inetAddress) {
                return true;
            }
        };
    }

    public boolean containsHost(String hostname) throws UnknownHostException {
        return this.containsAny(InetAddress.getAllByName(hostname));
    }

    public boolean containsAny(InetAddress[] inetAddresses) {
        for (InetAddress inetAddress : inetAddresses) {
            if (!this.contains(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(InetAddress inetAddress) {
        return IPMatcher.match(inetAddress, this.getSubnetAddress(), this.getMask());
    }

    public String toString() {
        if (this._subnetAddress == null) {
            return ALL_SUBNET;
        }
        if (this._subnetAddress instanceof Inet6Address) {
            return this._subnetAddress.getHostAddress().replaceFirst("(^|:)(0(:|$)){2,}", "::") + "/" + this._mask;
        }
        return this._subnetAddress.getHostAddress() + "/" + this._mask;
    }
}

