/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;

public class URIs {
    private static final Map<String, Integer> TO_DEFAULT_PORT = ImmutableMap.builder().put((Object)"ftp", (Object)21).put((Object)"http", (Object)80).put((Object)"https", (Object)443).put((Object)"gsiftp", (Object)2811).put((Object)"gridftp", (Object)2811).put((Object)"ldap", (Object)389).put((Object)"ldaps", (Object)636).put((Object)"srm", (Object)8443).build();

    private URIs() {
    }

    public static int portWithDefault(URI uri) {
        return URIs.portWithDefault(uri, null, -1);
    }

    public static Optional<Integer> optionalPortWithDefault(URI uri) {
        int port = URIs.portWithDefault(uri, null, -1);
        return port > -1 ? Optional.of(port) : Optional.empty();
    }

    public static int portWithDefault(URI uri, String defaultScheme, int defaultPort) {
        String scheme;
        int port = uri.getPort();
        if (uri.getPort() == -1 && (scheme = uri.getScheme()) != null) {
            if (scheme.equals(defaultScheme)) {
                port = defaultPort;
            } else {
                Integer fromDefaults = TO_DEFAULT_PORT.get(scheme);
                if (fromDefaults != null) {
                    port = fromDefaults;
                }
            }
        }
        return port;
    }

    private static boolean isDefaultPortNeeded(URI uri) {
        return uri.getPort() == -1 && uri.getHost() != null;
    }

    public static URI withDefaultPort(URI uri, String scheme, int port) {
        int defaultPort;
        if (URIs.isDefaultPortNeeded(uri) && (defaultPort = URIs.portWithDefault(uri, scheme, port)) != -1) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), defaultPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to add default port: " + e.getMessage(), e);
            }
        }
        return uri;
    }

    public static URI withDefaultPort(URI uri) {
        return URIs.withDefaultPort(uri, null, -1);
    }

    public static URI createWithDefaultPort(String uri, String scheme, int port) throws URISyntaxException {
        return URIs.withDefaultPort(new URI(uri), scheme, port);
    }

    public static URI createWithDefaultPort(String uri) throws URISyntaxException {
        return URIs.withDefaultPort(new URI(uri));
    }
}

