/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Xattrs {
    private static final String XATTR_PREFIX = "xattr.";

    private Xattrs() {
    }

    public static Map<String, String> from(URI uri) {
        Objects.requireNonNull(uri, "URI must be provided");
        String query = uri.getQuery();
        if (Strings.isNullOrEmpty((String)query)) {
            return Collections.emptyMap();
        }
        return Splitter.on((char)'&').withKeyValueSeparator("=").split((CharSequence)query).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(XATTR_PREFIX)).collect(Collectors.toMap(Xattrs::getName, Map.Entry::getValue));
    }

    public static Map<String, String> from(Map<String, String> params) {
        Objects.requireNonNull(params, "Params must be provided");
        return params.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(XATTR_PREFIX)).collect(Collectors.toMap(Xattrs::getName, Map.Entry::getValue));
    }

    private static String getName(Map.Entry<String, String> entry) {
        return entry.getKey().substring(XATTR_PREFIX.length());
    }
}

