/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.backoff;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.dcache.util.backoff.IBackoffAlgorithm;
import org.dcache.util.backoff.IBackoffAlgorithmFactory;

public class ExponentialBackoffAlgorithmFactory
implements IBackoffAlgorithmFactory {
    private Long maxDelay;
    private Long minDelay = 1L;
    private TimeUnit maxUnit = TimeUnit.MINUTES;
    private TimeUnit minUnit = TimeUnit.MINUTES;
    private Integer maxAllowedAttempts;
    private boolean quitAtMaxDelay;

    @Override
    public IBackoffAlgorithm getAlgorithm() {
        ExponentialBackoffAlgorithm algorithm = new ExponentialBackoffAlgorithm();
        algorithm.minDelayInMillis = this.minUnit.toMillis(this.minDelay);
        if (this.maxDelay != null) {
            algorithm.maxDelayInMillis = this.maxUnit.toMillis(this.maxDelay);
            Preconditions.checkArgument((algorithm.maxDelayInMillis >= algorithm.minDelayInMillis ? 1 : 0) != 0);
        }
        return algorithm;
    }

    public void setMaxAllowedAttempts(Integer maxAllowedAttempts) {
        this.maxAllowedAttempts = maxAllowedAttempts;
    }

    public void setMaxDelay(Long maxDelay) {
        this.maxDelay = maxDelay;
    }

    public void setMaxUnit(TimeUnit maxUnit) {
        Objects.requireNonNull(maxUnit);
        this.maxUnit = maxUnit;
    }

    public void setMinDelay(Long minDelay) {
        Objects.requireNonNull(minDelay);
        Preconditions.checkArgument((minDelay > 0L ? 1 : 0) != 0);
        this.minDelay = minDelay;
    }

    public void setMinUnit(TimeUnit minUnit) {
        Objects.requireNonNull(minUnit);
        this.minUnit = minUnit;
    }

    public void setQuitAtMaxDelay(boolean quitAtMaxDelay) {
        this.quitAtMaxDelay = quitAtMaxDelay;
    }

    private class ExponentialBackoffAlgorithm
    implements IBackoffAlgorithm {
        private Long maxDelayInMillis;
        private Long minDelayInMillis;
        private long previousDelay;
        private int previousAttempts;

        private ExponentialBackoffAlgorithm() {
        }

        @Override
        public long getWaitDuration() {
            if (this.previousDelay == -1L) {
                return this.previousDelay;
            }
            this.previousDelay = this.previousDelay == 0L ? this.minDelayInMillis : (this.minDelayInMillis + 2L * this.previousDelay) / 2L;
            if (this.maxDelayInMillis != null) {
                if (this.previousDelay > this.maxDelayInMillis || this.previousDelay <= 0L) {
                    this.previousDelay = this.maxDelayInMillis;
                }
                if (ExponentialBackoffAlgorithmFactory.this.quitAtMaxDelay && this.previousDelay == this.maxDelayInMillis) {
                    this.previousDelay = -1L;
                }
            }
            if (ExponentialBackoffAlgorithmFactory.this.maxAllowedAttempts != null && ++this.previousAttempts >= ExponentialBackoffAlgorithmFactory.this.maxAllowedAttempts) {
                this.previousDelay = -1L;
            }
            return this.previousDelay;
        }
    }
}

