/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.histograms;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.dcache.util.histograms.HistogramMetadata;
import org.dcache.util.histograms.HistogramModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountingHistogram
extends HistogramModel {
    private static final String UNSUPPORTED_UPDATE = "update not supported on this histogram type: " + CountingHistogram.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(CountingHistogram.class);

    public CountingHistogram() {
    }

    public CountingHistogram(CountingHistogram copy) {
        super(copy);
    }

    @Override
    public void configure() {
        int computedCount;
        Objects.requireNonNull(this.data, "no values set.");
        Objects.requireNonNull(this.binCount, "bin count must be defined.");
        Preconditions.checkArgument((this.binCount > 1 ? 1 : 0) != 0, (Object)"bin count must be > 1.");
        Objects.requireNonNull(this.binUnit, "bin unit must be defined.");
        Preconditions.checkArgument((this.binUnit > 0.0 ? 1 : 0) != 0, (Object)"bin unit must be > 0.");
        this.computeBinSizeFromWidthAndUnit();
        this.metadata = new HistogramMetadata();
        this.updateStatistics();
        Double max = this.metadata.getMaxValue().orElse(null);
        Double min = FastMath.min((double)0.0, (double)this.metadata.getMinValue().orElse(0.0));
        double maxIndex = max == null ? (double)(this.binCount - 1) : FastMath.floor((double)((max - min) / this.binSize));
        this.binWidth = (int)FastMath.ceil((double)(maxIndex / (double)(this.binCount - 1)));
        this.computeBinSizeFromWidthAndUnit();
        long[] histogram = new long[this.binCount.intValue()];
        LOGGER.debug("Preparing to compute bin values from dataset; bin size {}, bin count {}, min value {}, max value {}, max index.", new Object[]{this.binSize, this.binCount, min, max, maxIndex});
        for (Double d : this.data) {
            int n = (int)FastMath.floor((double)((d - min) / this.binSize));
            histogram[n] = histogram[n] + 1L;
        }
        this.data = new ArrayList();
        for (Object d : (Object)histogram) {
            this.data.add((double)d);
        }
        this.lowestBin = min;
        this.setHighestFromLowest();
        int n = computedCount = (int)this.binSize == 0 ? this.binCount : (int)FastMath.ceil((double)((this.highestBin - this.lowestBin) / this.binSize)) + 1;
        if (computedCount > this.binCount) {
            throw new RuntimeException("bin count " + this.binCount + " is less than " + computedCount + ", computed from bin width, highest and lowest bin values; this is a bug.");
        }
    }
}

