/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.histograms;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.math3.util.FastMath;

public final class HistogramMetadata
implements Serializable {
    private long lastUpdateInMillis;
    private long count = 0L;
    private Double maxValue;
    private Double minValue;
    private double sum = 0.0;
    private double sumOfSquares = 0.0;
    private int[] binCounts;
    private long[] binTimestamps;
    private int numBins = 0;
    private int start = 0;

    public HistogramMetadata() {
    }

    public HistogramMetadata(int numBins) {
        this.numBins = numBins;
        this.binCounts = new int[numBins];
        this.binTimestamps = new long[numBins];
        long now = System.currentTimeMillis();
        for (int i = 0; i < numBins; ++i) {
            this.binTimestamps[i] = now;
        }
    }

    public HistogramMetadata(HistogramMetadata copy) {
        Objects.requireNonNull(copy, "Metadata copy object is null.");
        this.lastUpdateInMillis = copy.lastUpdateInMillis;
        this.count = copy.count;
        this.maxValue = copy.maxValue;
        this.minValue = copy.minValue;
        this.sum = copy.sum;
        this.sumOfSquares = copy.sumOfSquares;
        this.binCounts = Arrays.copyOf(copy.binCounts, copy.binCounts.length);
        this.binTimestamps = Arrays.copyOf(copy.binTimestamps, copy.binTimestamps.length);
        this.numBins = copy.numBins;
        this.start = copy.start;
    }

    public int[] getBinCounts() {
        return this.binCounts;
    }

    public long[] getBinTimestamps() {
        return this.binTimestamps;
    }

    public long getCount() {
        return this.count;
    }

    public long getLastUpdateInMillis() {
        return this.lastUpdateInMillis;
    }

    public Optional<Double> getMaxValue() {
        return Optional.ofNullable(this.maxValue);
    }

    public Optional<Double> getMinValue() {
        return Optional.ofNullable(this.minValue);
    }

    public int getNumBins() {
        return this.numBins;
    }

    public int getStart() {
        return this.start;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public HistogramMetadata mergeStatistics(HistogramMetadata metadata) {
        Objects.requireNonNull(metadata, "Cannot merge statistics, metadata object was null.");
        this.count += metadata.count;
        this.sum += metadata.sum;
        this.sumOfSquares += metadata.sumOfSquares;
        if (metadata.maxValue != null) {
            this.maxValue = this.maxValue == null ? metadata.maxValue : FastMath.max((double)this.maxValue, (double)metadata.maxValue);
        }
        if (metadata.minValue != null) {
            this.minValue = this.minValue == null ? metadata.minValue : FastMath.min((double)this.minValue, (double)metadata.minValue);
        }
        return this;
    }

    public void rotate(int units) {
        units = units >= this.numBins ? this.numBins : units;
        long now = System.currentTimeMillis();
        for (int i = this.start; i < units; ++i) {
            this.binCounts[i % this.numBins] = 0;
            this.binTimestamps[i % this.numBins] = now;
        }
        this.start = units == this.numBins ? 0 : (this.start + units) % this.numBins;
    }

    public void setBinCounts(int[] binCounts) {
        this.binCounts = binCounts;
    }

    public void setBinTimestamps(long[] binTimestamps) {
        this.binTimestamps = binTimestamps;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setLastUpdateInMillis(long lastUpdateInMillis) {
        this.lastUpdateInMillis = lastUpdateInMillis;
    }

    public void setMaxValue(Optional<Double> maxValue) {
        this.maxValue = maxValue.orElse(null);
    }

    public void setMinValue(Optional<Double> minValue) {
        this.minValue = minValue.orElse(null);
    }

    public void setNumBins(int numBins) {
        this.numBins = numBins;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public void setSumOfSquares(double sumOfSquares) {
        this.sumOfSquares = sumOfSquares;
    }

    public double standardDeviation() {
        if (this.count == 0L) {
            return 0.0;
        }
        double variance = this.sumOfSquares / (double)this.count - FastMath.pow((double)(this.sum / (double)this.count), (int)2);
        return FastMath.sqrt((double)variance);
    }

    public int updateCountForBin(int index, long timestamp) {
        if (index < 0 || this.numBins <= index) {
            throw new ArrayIndexOutOfBoundsException("bin " + index + " does not exist");
        }
        int n = index = this.rotatedIndex(index);
        this.binCounts[n] = this.binCounts[n] + 1;
        this.binTimestamps[index] = timestamp;
        return this.binCounts[index];
    }

    public HistogramMetadata updateStatistics(Double lastValue, long now) {
        Objects.requireNonNull(lastValue, "Can only update using nonnull value.");
        ++this.count;
        this.sum += lastValue.doubleValue();
        this.sumOfSquares += FastMath.pow((double)lastValue, (long)2L);
        this.maxValue = this.maxValue == null ? lastValue : FastMath.max((double)lastValue, (double)this.maxValue);
        this.minValue = this.minValue == null ? lastValue : FastMath.min((double)lastValue, (double)this.minValue);
        this.lastUpdateInMillis = now;
        return this;
    }

    @VisibleForTesting
    int rotatedIndex(int index) {
        return (this.start + index) % this.numBins;
    }
}

