/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.histograms;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dcache.util.histograms.Histogram;
import org.dcache.util.histograms.HistogramMetadata;

public abstract class HistogramModel
implements Serializable {
    private static final String DATA_SIZE_ERROR = "Template was not properly configured: bin count %s does not match data size %s.";
    protected Integer binCount;
    protected Integer binWidth;
    protected Double binUnit;
    protected Double highestBin;
    protected Double lowestBin;
    protected String identifier;
    protected String binUnitLabel;
    protected String dataUnitLabel;
    protected HistogramMetadata metadata;
    protected List<Double> data;
    protected double binSize;

    protected HistogramModel() {
    }

    protected HistogramModel(HistogramModel copy) {
        Objects.requireNonNull(copy);
        this.binCount = copy.binCount;
        this.binWidth = copy.binWidth;
        this.binUnit = copy.binUnit;
        this.highestBin = copy.highestBin;
        this.lowestBin = copy.lowestBin;
        this.identifier = copy.identifier;
        this.binUnitLabel = copy.binUnitLabel;
        this.dataUnitLabel = copy.dataUnitLabel;
        this.metadata = copy.metadata;
        this.binSize = copy.binSize;
        if (copy.data != null) {
            this.data = new ArrayList<Double>(copy.data);
        }
    }

    public Integer getBinCount() {
        return this.binCount;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public Double getBinUnit() {
        return this.binUnit;
    }

    public String getBinUnitLabel() {
        return this.binUnitLabel;
    }

    public Integer getBinWidth() {
        return this.binWidth;
    }

    public List<Double> getData() {
        return this.data;
    }

    public String getDataUnitLabel() {
        return this.dataUnitLabel;
    }

    public Double getHighestBin() {
        return this.highestBin;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Double getLowestBin() {
        return this.lowestBin;
    }

    public HistogramMetadata getMetadata() {
        return this.metadata;
    }

    public void setBinCount(Integer binCount) {
        this.binCount = binCount;
    }

    public void setBinSize(double binSize) {
        this.binSize = binSize;
    }

    public void setBinUnit(Double binUnit) {
        this.binUnit = binUnit;
    }

    public void setBinUnitLabel(String binUnitLabel) {
        this.binUnitLabel = binUnitLabel;
    }

    public void setBinWidth(Integer binWidth) {
        this.binWidth = binWidth;
    }

    public void setData(List<Double> data) {
        this.data = data;
    }

    public void setDataUnitLabel(String dataUnitLabel) {
        this.dataUnitLabel = dataUnitLabel;
    }

    public void setHighestBin(Double highestBin) {
        this.highestBin = highestBin;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLowestBin(Double lowestBin) {
        this.lowestBin = lowestBin;
    }

    public void setMetadata(HistogramMetadata metadata) {
        this.metadata = metadata;
    }

    public Histogram toHistogram() {
        Histogram histogram = new Histogram();
        histogram.setIdentifier(Objects.requireNonNull(this.identifier, "No histogram identifier provided."));
        Objects.requireNonNull(this.binUnit, "No histogram binUnit provided.");
        Objects.requireNonNull(this.binWidth, "No histogram binWidth provided.");
        histogram.setBinSize(this.binUnit * (double)this.binWidth.intValue());
        histogram.setBinUnit(Objects.requireNonNull(this.binUnitLabel, "No histogram bin label provided."));
        histogram.setDataUnit(Objects.requireNonNull(this.dataUnitLabel, "No histogram data label provided."));
        histogram.setLowestBin(Objects.requireNonNull(this.lowestBin, "Lowest histogram bin not provided."));
        int len = Objects.requireNonNull(this.binCount, "No histogram bin count provided.");
        Objects.requireNonNull(this.data, "Histogram data list missing.");
        Preconditions.checkArgument((this.data.size() == len ? 1 : 0) != 0, (Object)String.format(DATA_SIZE_ERROR, this.binCount, this.data.size()));
        Double[][] values = new Double[this.binCount.intValue()][];
        for (int i = 0; i < this.binCount; ++i) {
            values[i] = new Double[]{this.lowestBin + (double)i * this.binSize, this.data.get(i)};
        }
        histogram.setValues(values);
        return histogram;
    }

    public abstract void configure();

    protected void computeBinSizeFromWidthAndUnit() {
        if (this.binWidth == null) {
            this.binWidth = 1;
        }
        this.binSize = this.binWidth == 0 ? this.binUnit : this.binUnit * (double)this.binWidth.intValue();
    }

    protected double getHighestFromLowest() {
        return this.lowestBin + (double)(this.binCount - 1) * this.binSize;
    }

    protected double getLowestFromHighest() {
        return this.highestBin - (double)(this.binCount - 1) * this.binSize;
    }

    protected void setHighestFromLowest() {
        if (this.highestBin == null) {
            this.highestBin = this.getHighestFromLowest();
        }
    }

    protected void setLowestFromHighest() {
        if (this.lowestBin == null) {
            this.lowestBin = this.getLowestFromHighest();
        }
    }

    protected void updateStatistics() {
        if (this.metadata == null) {
            return;
        }
        long now = System.currentTimeMillis();
        for (Double d : this.data) {
            if (d == null) continue;
            this.metadata.updateStatistics(d, now);
        }
    }
}

