/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.histograms;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.dcache.util.histograms.HistogramMetadata;
import org.dcache.util.histograms.HistogramModel;
import org.dcache.util.histograms.TimeFrame;
import org.dcache.util.histograms.UpdatableHistogramModel;

public class TimeseriesHistogram
extends HistogramModel
implements UpdatableHistogramModel {
    public TimeseriesHistogram() {
    }

    public TimeseriesHistogram(TimeseriesHistogram copy) {
        super(copy);
    }

    @Override
    public void add(Double value, Long timestamp) {
        this.update(value, UpdateOperation.SUM, timestamp);
    }

    @Override
    public void average(Double value, Long timestamp) {
        this.update(value, UpdateOperation.AVERAGE, timestamp);
    }

    @Override
    public void configure() {
        Objects.requireNonNull(this.identifier, "histogram type must be defined.");
        Objects.requireNonNull(this.binCount, "bin count must be defined.");
        Preconditions.checkArgument((this.binCount > 1 ? 1 : 0) != 0, (Object)"bin count must be > 1.");
        Objects.requireNonNull(this.binUnit, "bin unit must be defined.");
        Preconditions.checkArgument((this.binUnit > 0.0 ? 1 : 0) != 0, (Object)"bin unit must be > 0.");
        Objects.requireNonNull(this.highestBin, "highest bin must be defined.");
        this.computeBinSizeFromWidthAndUnit();
        this.setLowestFromHighest();
        boolean emptyData = true;
        if (this.data == null) {
            this.data = new ArrayList();
        } else {
            this.data = new ArrayList(this.data);
            emptyData = this.data.isEmpty();
        }
        if (emptyData) {
            for (int i = 0; i < this.binCount; ++i) {
                this.data.add(null);
            }
        }
        String error = "bin count %s does not match array size %s.";
        Preconditions.checkArgument((this.data.size() == this.binCount.intValue() ? 1 : 0) != 0, (Object)String.format(error, this.binCount, this.data.size()));
        if (this.metadata == null) {
            this.metadata = new HistogramMetadata(this.binCount);
            if (!emptyData) {
                long now = System.currentTimeMillis();
                for (int i = 0; i < this.binCount; ++i) {
                    this.metadata.updateCountForBin(i, now);
                }
            }
            this.updateStatistics();
        }
    }

    @Override
    public void replace(Double value, Long timestamp) {
        this.update(value, UpdateOperation.REPLACE, timestamp);
    }

    public void withTimeFrame(TimeFrame timeFrame) {
        timeFrame.configure();
        this.binCount = timeFrame.getBinCount();
        this.binUnit = timeFrame.getBinWidth();
        this.binWidth = 1000;
        this.binUnitLabel = timeFrame.getTimebin().name();
        double binSize = this.binUnit * (double)this.binWidth.intValue();
        this.highestBin = (double)timeFrame.getHighTime().longValue() - binSize;
        this.lowestBin = (double)timeFrame.getLowTime();
    }

    private int findTimebinIndex(long timestamp) {
        return (int)FastMath.floor((double)(((double)timestamp - this.lowestBin) / this.binSize));
    }

    private int rotateBuffer(int binIndex) {
        int units = binIndex - this.binCount + 1;
        int len = units >= this.binCount ? binIndex : units;
        for (int i = 0; i < len; ++i) {
            this.data.remove(0);
            this.data.add(null);
        }
        this.metadata.rotate(units);
        this.lowestBin = this.lowestBin + this.binSize * (double)units;
        this.highestBin = this.highestBin + this.binSize * (double)units;
        return this.binCount - 1;
    }

    private void update(Double value, UpdateOperation operation, Long timestamp) {
        int binIndex = this.findTimebinIndex(timestamp);
        if (binIndex < 0) {
            return;
        }
        if (binIndex >= this.binCount) {
            binIndex = this.rotateBuffer(binIndex);
        }
        int count = this.metadata.updateCountForBin(binIndex, timestamp);
        if (value == null) {
            if (operation == UpdateOperation.REPLACE) {
                this.data.set(binIndex, value);
            }
        } else {
            switch (operation) {
                case REPLACE: {
                    this.data.set(binIndex, value);
                    break;
                }
                case SUM: {
                    Double d = (Double)this.data.get(binIndex);
                    this.data.set(binIndex, d == null ? value : d + value);
                    break;
                }
                case AVERAGE: {
                    Double d = (Double)this.data.get(binIndex);
                    this.data.set(binIndex, d == null ? value : (d + value) / (double)count);
                }
            }
            this.metadata.updateStatistics(value, timestamp);
        }
    }

    static enum UpdateOperation {
        SUM,
        AVERAGE,
        REPLACE;

    }
}

