/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.nearline;

import com.google.common.base.Preconditions;
import diskCacheV111.util.InProgressCacheException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dcache.pool.nearline.spi.FlushRequest;
import org.dcache.pool.nearline.spi.NearlineRequest;
import org.dcache.pool.nearline.spi.NearlineStorage;
import org.dcache.pool.nearline.spi.RemoveRequest;
import org.dcache.pool.nearline.spi.StageRequest;
import org.dcache.util.Checksum;
import org.dcache.util.NDC;
import org.dcache.vehicles.FileAttributes;

public abstract class AbstractBlockingNearlineStorage
implements NearlineStorage {
    protected final String type;
    protected final String name;
    private final Map<UUID, Task<?, ?>> requests = new ConcurrentHashMap();

    public AbstractBlockingNearlineStorage(String type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public void cancel(UUID uuid) {
        Task<?, ?> task = this.requests.get(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public void flush(Iterable<FlushRequest> requests) {
        for (FlushRequest request : requests) {
            Task<FlushRequest, Set<URI>> task = new Task<FlushRequest, Set<URI>>(request){

                @Override
                public Set<URI> call() throws Exception {
                    FileAttributes fileAttributes = ((FlushRequest)this.request).getFileAttributes();
                    NDC.push((String)fileAttributes.getPnfsId().toString());
                    try {
                        Set<URI> set = AbstractBlockingNearlineStorage.this.flush((FlushRequest)this.request);
                        return set;
                    }
                    finally {
                        NDC.pop();
                    }
                }

                @Override
                protected void execute() {
                    AbstractBlockingNearlineStorage.this.getFlushExecutor().execute(this);
                }
            };
            task.execute();
        }
    }

    @Override
    public void stage(Iterable<StageRequest> requests) {
        for (StageRequest request : requests) {
            Task<StageRequest, Set<Checksum>> task = new Task<StageRequest, Set<Checksum>>(request){

                @Override
                public Set<Checksum> call() throws Exception {
                    FileAttributes attributes = ((StageRequest)this.request).getFileAttributes();
                    NDC.push((String)attributes.getPnfsId().toString());
                    try {
                        ((StageRequest)this.request).allocate().get();
                        Set<Checksum> set = AbstractBlockingNearlineStorage.this.stage((StageRequest)this.request);
                        return set;
                    }
                    finally {
                        NDC.pop();
                    }
                }

                @Override
                protected void execute() {
                    AbstractBlockingNearlineStorage.this.getStageExecutor().execute(this);
                }
            };
            task.execute();
        }
    }

    @Override
    public void remove(Iterable<RemoveRequest> requests) {
        for (RemoveRequest request : requests) {
            Task<RemoveRequest, Void> task = new Task<RemoveRequest, Void>(request){

                @Override
                public Void call() throws Exception {
                    NDC.push((String)((RemoveRequest)this.request).getUri().toString());
                    try {
                        AbstractBlockingNearlineStorage.this.remove((RemoveRequest)this.request);
                    }
                    finally {
                        NDC.pop();
                    }
                    return null;
                }

                @Override
                protected void execute() {
                    AbstractBlockingNearlineStorage.this.getRemoveExecutor().execute(this);
                }
            };
            task.execute();
        }
    }

    @Override
    public void shutdown() {
        this.requests.values().forEach(Task::cancel);
    }

    protected List<URI> getLocations(FileAttributes fileAttributes) {
        return this.filteredLocations(fileAttributes).collect(Collectors.toList());
    }

    private Stream<URI> filteredLocations(FileAttributes fileAttributes) {
        return fileAttributes.getStorageInfo().locations().stream().filter(uri -> uri.getScheme().equals(this.type)).filter(uri -> uri.getAuthority().equals(this.name));
    }

    protected abstract Executor getFlushExecutor();

    protected abstract Executor getStageExecutor();

    protected abstract Executor getRemoveExecutor();

    protected abstract Set<URI> flush(FlushRequest var1) throws Exception;

    protected abstract Set<Checksum> stage(StageRequest var1) throws Exception;

    protected abstract void remove(RemoveRequest var1) throws Exception;

    protected void retry(Runnable runnable) {
        runnable.run();
    }

    private static abstract class Task<R extends NearlineRequest<T>, T>
    implements Runnable {
        protected final R request;
        private Thread thread;
        private boolean isDone;
        private boolean isActivated;
        final /* synthetic */ AbstractBlockingNearlineStorage this$0;

        protected Task(R request) {
            this.this$0 = var1_1;
            this.request = request;
            var1_1.requests.put(request.getId(), this);
        }

        public synchronized void cancel() {
            if (!this.isDone) {
                this.isDone = true;
                if (this.thread != null) {
                    this.thread.interrupt();
                } else {
                    this.request.failed(new CancellationException());
                }
                this.this$0.requests.remove(this.request.getId());
            }
        }

        private synchronized boolean bind(Thread thread) {
            Preconditions.checkState((this.thread == null ? 1 : 0) != 0);
            if (this.isDone) {
                return false;
            }
            this.thread = thread;
            return true;
        }

        private synchronized void release(boolean isRetrying) throws CancellationException {
            this.thread = null;
            if (this.isDone) {
                throw new CancellationException();
            }
            if (!isRetrying) {
                this.isDone = true;
                this.this$0.requests.remove(this.request.getId());
            }
        }

        private synchronized boolean activate() {
            if (!this.isActivated) {
                this.isActivated = true;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            block13: {
                try {
                    Thread thread = Thread.currentThread();
                    if (!this.bind(thread)) break block13;
                    boolean isSuccess = false;
                    Object result = null;
                    try {
                        try {
                            result = this.processRequest();
                            this.release(false);
                            isSuccess = true;
                        }
                        catch (InProgressCacheException e) {
                            this.release(true);
                            throw e;
                        }
                        catch (Exception e) {
                            this.release(false);
                            throw e;
                        }
                        finally {
                            Thread.interrupted();
                        }
                    }
                    catch (InProgressCacheException e) {
                        this.this$0.retry(this::execute);
                    }
                    catch (InterruptedException e) {
                        this.request.failed(new CancellationException());
                    }
                    catch (Exception cause) {
                        this.request.failed(cause);
                    }
                    if (isSuccess) {
                        this.request.completed(result);
                    }
                }
                catch (Throwable e) {
                    this.thread.getUncaughtExceptionHandler().uncaughtException(this.thread, e);
                }
            }
        }

        private T processRequest() throws Throwable {
            if (this.activate()) {
                try {
                    this.request.activate().get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
            NDC.push((String)this.request.getId().toString());
            try {
                T t = this.call();
                return t;
            }
            finally {
                NDC.pop();
            }
        }

        protected abstract void execute();

        protected abstract T call() throws Exception;
    }
}

