/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.File;
import diskCacheV111.services.space.FileState;
import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.NoFreeSpaceException;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceException;
import diskCacheV111.services.space.SpaceExpiredException;
import diskCacheV111.services.space.SpaceManagerDatabase;
import diskCacheV111.services.space.SpaceReleasedException;
import diskCacheV111.services.space.SpaceState;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.VOInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dcache.util.SqlGlob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JdbcSpaceManagerDatabase
extends JdbcDaoSupport
implements SpaceManagerDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSpaceManagerDatabase.class);
    private static final String RETENTION_POLICY_TABLE = "srmretentionpolicy";
    private static final String ACCESS_LATENCY_TABLE = "srmaccesslatency";
    private static final String LINKGROUP_TABLE = "srmlinkgroup";
    private static final String LINKGROUP_VO_TABLE = "srmlinkgroupvos";
    private static final String SPACE_TABLE = "srmspace";
    private static final String SPACEFILE_TABLE = "srmspacefile";

    public void init() throws DataAccessException {
        this.insertRetentionPolicies();
        this.insertAccessLatencies();
    }

    private void insertRetentionPolicies() throws DataAccessException {
        RetentionPolicy[] policies = RetentionPolicy.getAllPolicies();
        Long cnt = (Long)this.getJdbcTemplate().queryForObject("SELECT count(*) FROM srmretentionpolicy", Long.class);
        if (cnt == (long)policies.length) {
            return;
        }
        for (RetentionPolicy policy : policies) {
            try {
                this.getJdbcTemplate().update("INSERT INTO srmretentionpolicy (id, name) VALUES (?,?)", new Object[]{policy.getId(), policy.toString()});
            }
            catch (DataAccessException sqle) {
                LOGGER.error("insert retention policy {} failed: {}", (Object)policy, (Object)sqle.getMessage());
            }
        }
    }

    private void insertAccessLatencies() throws DataAccessException {
        AccessLatency[] latencies = AccessLatency.getAllLatencies();
        Long cnt = (Long)this.getJdbcTemplate().queryForObject("SELECT count(*) from srmaccesslatency", Long.class);
        if (cnt == (long)latencies.length) {
            return;
        }
        for (AccessLatency latency : latencies) {
            try {
                this.getJdbcTemplate().update("INSERT INTO srmaccesslatency (id, name) VALUES (?,?)", new Object[]{latency.getId(), latency.toString()});
            }
            catch (DataAccessException sqle) {
                LOGGER.error("insert access latency {} failed: {}", (Object)latency, (Object)sqle.getMessage());
            }
        }
    }

    @Override
    public void removeFile(long fileId) throws DataAccessException {
        int rc = this.getJdbcTemplate().update("DELETE FROM srmspacefile WHERE id=?", new Object[]{fileId});
        if (rc > 1) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException("delete returned row count = " + rc, 1, rc);
        }
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY, noRollbackFor={EmptyResultDataAccessException.class})
    public Space selectSpaceForUpdate(long id) throws DataAccessException {
        try {
            return (Space)this.getJdbcTemplate().queryForObject("SELECT * FROM srmspace WHERE id = ? FOR UPDATE", this::toSpace, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("No such space reservation: " + id, 1, (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY, noRollbackFor={EmptyResultDataAccessException.class})
    public File selectFileForUpdate(PnfsId pnfsId) throws DataAccessException {
        try {
            return (File)this.getJdbcTemplate().queryForObject("SELECT * FROM srmspacefile WHERE pnfsid = ? FOR UPDATE ", this::toFile, new Object[]{pnfsId.toString()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("Space reservation for " + pnfsId + " not found.", 1, (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY, noRollbackFor={EmptyResultDataAccessException.class})
    public File selectFileForUpdate(long id) throws DataAccessException {
        try {
            return (File)this.getJdbcTemplate().queryForObject("SELECT * FROM srmspacefile WHERE id = ? FOR UPDATE ", this::toFile, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("No such file id: " + id, 1, (Throwable)e);
        }
    }

    @Override
    public Space updateSpace(Space space) throws DataAccessException {
        this.getJdbcTemplate().update("UPDATE srmspace SET vogroup=?,vorole=?,retentionpolicy=?,accesslatency=?,linkgroupid=?,sizeinbytes=?, creationtime=?,expirationTime=?,description=?,state=? WHERE id=?", new Object[]{space.getVoGroup(), space.getVoRole(), space.getRetentionPolicy().getId(), space.getAccessLatency().getId(), space.getLinkGroupId(), space.getSizeInBytes(), space.getCreationTime(), space.getExpirationTime(), space.getDescription(), space.getState().getStateId(), space.getId()});
        return space;
    }

    @Override
    @Transactional
    public long updateLinkGroup(String linkGroupName, long freeSpace, long updateTime, boolean onlineAllowed, boolean nearlineAllowed, boolean replicaAllowed, boolean outputAllowed, boolean custodialAllowed, VOInfo[] linkGroupVOs) throws DataAccessException {
        long id;
        try {
            id = (Long)this.getJdbcTemplate().queryForObject("SELECT id FROM srmlinkgroup WHERE name = ? FOR UPDATE", Long.class, new Object[]{linkGroupName});
            this.getJdbcTemplate().update("UPDATE srmlinkgroup SET availableSpaceInBytes=?-reservedSpaceInBytes,lastUpdateTime=?,onlineAllowed=?,nearlineAllowed=?,replicaAllowed=?,outputAllowed=?,custodialAllowed=? WHERE id = ?", new Object[]{freeSpace, updateTime, onlineAllowed ? 1 : 0, nearlineAllowed ? 1 : 0, replicaAllowed ? 1 : 0, outputAllowed ? 1 : 0, custodialAllowed ? 1 : 0, id});
        }
        catch (EmptyResultDataAccessException e) {
            try {
                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                this.getJdbcTemplate().update(con -> {
                    PreparedStatement stmt = con.prepareStatement("INSERT INTO srmlinkgroup (name, availableSpaceInBytes, lastUpdateTime, onlineAllowed, nearlineAllowed, replicaAllowed, outputAllowed, custodialAllowed,reservedspaceinbytes) VALUES (?,?,?,?,?,?,?,?,?)", 1);
                    stmt.setString(1, linkGroupName);
                    stmt.setLong(2, freeSpace);
                    stmt.setLong(3, updateTime);
                    stmt.setInt(4, onlineAllowed ? 1 : 0);
                    stmt.setInt(5, nearlineAllowed ? 1 : 0);
                    stmt.setInt(6, replicaAllowed ? 1 : 0);
                    stmt.setInt(7, outputAllowed ? 1 : 0);
                    stmt.setInt(8, custodialAllowed ? 1 : 0);
                    stmt.setLong(9, 0L);
                    return stmt;
                }, (KeyHolder)keyHolder);
                id = (Long)keyHolder.getKeys().get("id");
            }
            catch (DataAccessException e1) {
                LOGGER.error("failed to insert linkgroup {}: {}", (Object)linkGroupName, (Object)e.getMessage());
                throw e1;
            }
        }
        HashSet deleteVOs = new HashSet();
        HashSet<VOInfo> insertVOs = new HashSet<VOInfo>();
        if (linkGroupVOs != null) {
            insertVOs.addAll(Arrays.asList(linkGroupVOs));
        }
        this.getJdbcTemplate().query("SELECT VOGroup,VORole FROM srmlinkgroupvos WHERE linkGroupId=?", rs -> {
            String nextVORole;
            String nextVOGroup = rs.getString(1);
            VOInfo nextVO = new VOInfo(nextVOGroup, nextVORole = rs.getString(2));
            if (!insertVOs.remove(nextVO)) {
                deleteVOs.add(nextVO);
            }
        }, new Object[]{id});
        for (VOInfo nextVo : insertVOs) {
            this.getJdbcTemplate().update("INSERT INTO srmlinkgroupvos ( VOGroup, VORole, linkGroupId ) VALUES ( ? , ? , ? )", new Object[]{nextVo.getVoGroup(), nextVo.getVoRole(), id});
        }
        for (VOInfo nextVo : deleteVOs) {
            this.getJdbcTemplate().update("DELETE FROM srmlinkgroupvos WHERE VOGroup  = ? AND VORole = ? AND linkGroupId = ? ", new Object[]{nextVo.getVoGroup(), nextVo.getVoRole(), id});
        }
        return id;
    }

    @Override
    public Space insertSpace(String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long lifetime, String description, SpaceState state, long used, long allocated) throws DataAccessException {
        long creationTime = System.currentTimeMillis();
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int rc = this.getJdbcTemplate().update(con -> {
            PreparedStatement stmt = con.prepareStatement("INSERT INTO srmspace (vogroup,vorole,retentionpolicy,accesslatency,linkgroupid,sizeinbytes,creationtime,expirationtime,description,state,usedspaceinbytes,allocatedspaceinbytes) VALUES  (?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            stmt.setString(1, voGroup);
            stmt.setString(2, voRole);
            stmt.setInt(3, retentionPolicy == null ? 0 : retentionPolicy.getId());
            stmt.setInt(4, accessLatency == null ? 0 : accessLatency.getId());
            stmt.setLong(5, linkGroupId);
            stmt.setLong(6, sizeInBytes);
            stmt.setLong(7, creationTime);
            stmt.setObject(8, lifetime == -1L ? null : Long.valueOf(creationTime + lifetime));
            stmt.setString(9, description);
            stmt.setInt(10, state.getStateId());
            stmt.setLong(11, used);
            stmt.setLong(12, allocated);
            return stmt;
        }, (KeyHolder)keyHolder);
        if (rc != 1) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException("insert returned row count =" + rc, 1, rc);
        }
        return new Space(((Long)keyHolder.getKeys().get("id")).longValue(), voGroup, voRole, retentionPolicy, accessLatency, linkGroupId, sizeInBytes, creationTime, lifetime == -1L ? null : Long.valueOf(creationTime + lifetime), description, state, used, allocated);
    }

    @Override
    public Space getSpace(long id) throws DataAccessException {
        try {
            return (Space)this.getJdbcTemplate().queryForObject("SELECT * FROM srmspace WHERE id=?", this::toSpace, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("No such space reservation: " + id, 1, (Throwable)e);
        }
    }

    @Override
    public LinkGroup getLinkGroup(long id) throws DataAccessException {
        try {
            return (LinkGroup)this.getJdbcTemplate().queryForObject("SELECT * FROM srmlinkgroup WHERE  id = ?", this::toLinkGroup, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("No such link group: " + id, 1, (Throwable)e);
        }
    }

    @Override
    public LinkGroup getLinkGroupByName(String name) throws DataAccessException {
        try {
            return (LinkGroup)this.getJdbcTemplate().queryForObject("SELECT * FROM srmlinkgroup WHERE  name = ?", this::toLinkGroup, new Object[]{name});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmptyResultDataAccessException("No such link group: " + name, 1, (Throwable)e);
        }
    }

    @Override
    public void updateFile(File f) throws DataAccessException {
        int rc = this.getJdbcTemplate().update("UPDATE srmspacefile SET vogroup=?, vorole=?, sizeinbytes=?, pnfsid=?, state=? WHERE id=?", new Object[]{f.getVoGroup(), f.getVoRole(), f.getSizeInBytes(), Objects.toString(f.getPnfsId(), null), f.getState().getStateId(), f.getId()});
        if (rc != 1) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException("Update failed, row count=" + rc, 1, rc);
        }
    }

    @Override
    public File findFile(PnfsId pnfsId) throws DataAccessException {
        List results = this.getJdbcTemplate().query("SELECT * FROM srmspacefile WHERE pnfsId=?", this::toFile, new Object[]{pnfsId.toString()});
        return (File)DataAccessUtils.singleResult((Collection)results);
    }

    @Override
    public SpaceManagerDatabase.LinkGroupCriterion linkGroups() {
        return new LinkGroupCriterionImpl();
    }

    @Override
    public List<LinkGroup> get(SpaceManagerDatabase.LinkGroupCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().query("SELECT * from srmlinkgroup WHERE " + c.getPredicate(), c.getArguments(), this::toLinkGroup);
    }

    @Override
    public SpaceManagerDatabase.SpaceCriterion spaces() {
        return new SpaceCriterionImpl();
    }

    @Override
    public List<Space> get(SpaceManagerDatabase.SpaceCriterion criterion, Integer limit) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().query("SELECT * FROM srmspace WHERE " + c.getPredicate() + (limit != null ? " LIMIT " + limit : ""), c.getArguments(), this::toSpace);
    }

    @Override
    public List<Long> getSpaceTokensOf(SpaceManagerDatabase.SpaceCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().queryForList("SELECT id FROM srmspace WHERE " + c.getPredicate(), c.getArguments(), Long.class);
    }

    @Override
    public int count(SpaceManagerDatabase.SpaceCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return (Integer)this.getJdbcTemplate().queryForObject("SELECT count(*) FROM srmspace WHERE " + c.getPredicate(), c.getArguments(), Integer.class);
    }

    @Override
    public SpaceManagerDatabase.FileCriterion files() {
        return new FileCriterionImpl();
    }

    @Override
    public List<File> get(SpaceManagerDatabase.FileCriterion criterion, Integer limit) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().query("SELECT * FROM srmspacefile WHERE " + c.getPredicate() + (limit != null ? " LIMIT " + limit : ""), c.getArguments(), this::toFile);
    }

    @Override
    public int count(SpaceManagerDatabase.FileCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return (Integer)this.getJdbcTemplate().queryForObject("SELECT count(*) FROM srmspacefile WHERE " + c.getPredicate(), c.getArguments(), Integer.class);
    }

    @Override
    public int remove(SpaceManagerDatabase.FileCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().update("DELETE FROM srmspacefile WHERE " + c.getPredicate(), c.getArguments());
    }

    @Override
    public int remove(SpaceManagerDatabase.SpaceCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        return this.getJdbcTemplate().update("DELETE FROM srmspace WHERE " + c.getPredicate(), c.getArguments());
    }

    @Override
    public long insertFile(long reservationId, String voGroup, String voRole, long sizeInBytes, PnfsId pnfsId, FileState state) throws DataAccessException, SpaceException {
        long creationTime = System.currentTimeMillis();
        Space space = this.selectSpaceForUpdate(reservationId);
        long currentTime = System.currentTimeMillis();
        if (space.getExpirationTime() != null && space.getExpirationTime() <= currentTime) {
            throw new SpaceExpiredException("space with id=" + reservationId + " has expired");
        }
        if (space.getState() == SpaceState.EXPIRED) {
            throw new SpaceExpiredException("space with id=" + reservationId + " has expired");
        }
        if (space.getState() == SpaceState.RELEASED) {
            throw new SpaceReleasedException("space with id=" + reservationId + " was released");
        }
        if (space.getAvailableSpaceInBytes() < sizeInBytes) {
            throw new NoFreeSpaceException("space with id=" + reservationId + " does not have enough space");
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int rc = this.getJdbcTemplate().update(con -> {
            PreparedStatement stmt = con.prepareStatement("INSERT INTO srmspacefile (vogroup,vorole,spacereservationid,sizeinbytes,creationtime,pnfsid,state)  VALUES  (?,?,?,?,?,?,?)", 1);
            stmt.setString(1, voGroup);
            stmt.setString(2, voRole);
            stmt.setLong(3, reservationId);
            stmt.setLong(4, sizeInBytes);
            stmt.setLong(5, creationTime);
            stmt.setString(6, Objects.toString(pnfsId, null));
            stmt.setInt(7, state.getStateId());
            return stmt;
        }, (KeyHolder)keyHolder);
        if (rc != 1) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException("insert returned row count =" + rc, 1, rc);
        }
        return (Long)keyHolder.getKeys().get("id");
    }

    @Override
    public void expire(SpaceManagerDatabase.SpaceCriterion criterion) {
        JdbcCriterion c = (JdbcCriterion)((Object)criterion);
        this.getJdbcTemplate().update("UPDATE srmspace SET state = " + SpaceState.EXPIRED.getStateId() + " WHERE " + c.getPredicate(), c.getArguments());
    }

    private Space toSpace(ResultSet set, int rowNum) throws SQLException {
        return new Space(set.getLong("id"), set.getString("vogroup"), set.getString("vorole"), RetentionPolicy.getRetentionPolicy((int)set.getInt("retentionPolicy")), AccessLatency.getAccessLatency((int)set.getInt("accessLatency")), set.getLong("linkgroupid"), set.getLong("sizeinbytes"), set.getLong("creationtime"), JdbcSpaceManagerDatabase.toNull(set.getLong("expirationtime"), set.wasNull()), set.getString("description"), SpaceState.valueOf((int)set.getInt("state")), set.getLong("usedspaceinbytes"), set.getLong("allocatedspaceinbytes"));
    }

    private LinkGroup toLinkGroup(ResultSet set, int rowNum) throws SQLException {
        LinkGroup lg = new LinkGroup();
        lg.setId(set.getLong("id"));
        lg.setName(set.getString("name"));
        lg.setAvailableSpace(set.getLong("availablespaceinbytes"));
        lg.setUpdateTime(set.getLong("lastupdatetime"));
        lg.setOnlineAllowed(set.getBoolean("onlineallowed"));
        lg.setNearlineAllowed(set.getBoolean("nearlineallowed"));
        lg.setReplicaAllowed(set.getBoolean("replicaallowed"));
        lg.setOutputAllowed(set.getBoolean("outputallowed"));
        lg.setCustodialAllowed(set.getBoolean("custodialallowed"));
        lg.setReservedSpace(set.getLong("reservedspaceinbytes"));
        List vos = this.getJdbcTemplate().query("SELECT voGroup,voRole FROM srmlinkgroupvos WHERE linkGroupId=?", (vo, i) -> new VOInfo(vo.getString("vogroup"), vo.getString("vorole")), new Object[]{lg.getId()});
        lg.setVOs(vos.toArray(new VOInfo[vos.size()]));
        return lg;
    }

    private File toFile(ResultSet set, int rowNum) throws SQLException {
        String pnfsId = set.getString("pnfsId");
        return new File(set.getLong("id"), set.getString("vogroup"), set.getString("vorole"), set.getLong("spacereservationid"), set.getLong("sizeinbytes"), set.getLong("creationtime"), pnfsId != null ? new PnfsId(pnfsId) : null, FileState.valueOf(set.getInt("state")));
    }

    private static <T> T toNull(T value, boolean makeNull) {
        return makeNull ? null : (T)value;
    }

    private static class FileCriterionImpl
    extends JdbcCriterion
    implements SpaceManagerDatabase.FileCriterion {
        private FileCriterionImpl() {
        }

        @Override
        public SpaceManagerDatabase.FileCriterion whereGroupMatches(SqlGlob group) {
            this.whereFieldMatches("group", group);
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion whereRoleMatches(SqlGlob role) {
            this.whereFieldMatches("role", role);
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion whereSpaceTokenIs(Long token) {
            this.addClause("spacereservationid = ?", token);
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion whereStateIsIn(FileState ... states) {
            this.addClause(Stream.of(states).mapToInt(FileState::getStateId).mapToObj(String::valueOf).collect(Collectors.joining(",", "state IN (", ")")), new Object[0]);
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion wherePnfsIdIs(PnfsId pnfsId) {
            this.addClause("pnfsid = ?", pnfsId.toString());
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion in(SpaceManagerDatabase.SpaceCriterion spaceCriterion) {
            JdbcCriterion criterion = (JdbcCriterion)((Object)spaceCriterion);
            this.addClause("spacereservationid IN (SELECT id FROM srmspace WHERE " + criterion.getPredicate() + ")", criterion.getArguments());
            return this;
        }

        @Override
        public SpaceManagerDatabase.FileCriterion whereCreationTimeIsBefore(long millis) {
            this.addClause("creationtime < ?", millis);
            return this;
        }
    }

    private static class SpaceCriterionImpl
    extends JdbcCriterion
    implements SpaceManagerDatabase.SpaceCriterion {
        private SpaceCriterionImpl() {
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereStateIsIn(SpaceState ... states) {
            this.addClause(Stream.of(states).mapToInt(SpaceState::getStateId).mapToObj(String::valueOf).collect(Collectors.joining(",", "state IN (", ")")), new Object[0]);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereRetentionPolicyIs(RetentionPolicy rp) {
            this.addClause("retentionpolicy = ?", rp.getId());
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereAccessLatencyIs(AccessLatency al) {
            this.addClause("accesslatency = ?", al.getId());
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereDescriptionMatches(SqlGlob desc) {
            this.whereFieldMatches("description", desc);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereRoleMatches(SqlGlob role) {
            this.whereFieldMatches("vorole", role);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereGroupMatches(SqlGlob group) {
            this.whereFieldMatches("vogroup", group);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereTokenIs(long token) {
            this.addClause("id = ?", token);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion thatNeverExpire() {
            this.addClause("expirationtime IS NULL", new Object[0]);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereLinkGroupIs(long id) {
            this.addClause("linkgroupid = ?", id);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereGroupIs(String group) {
            this.addClause("vogroup = ?", group);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereRoleIs(String role) {
            this.addClause("vorole = ?", role);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion whereDescriptionIs(String description) {
            this.addClause("description = ?", description);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion thatExpireBefore(long millis) {
            this.addClause("expirationtime < ?", millis);
            return this;
        }

        @Override
        public SpaceManagerDatabase.SpaceCriterion thatHaveNoFiles() {
            this.addClause("NOT EXISTS (SELECT * FROM srmspacefile WHERE spacereservationid = srmspace.id)", new Object[0]);
            return this;
        }
    }

    private static class LinkGroupCriterionImpl
    extends JdbcCriterion
    implements SpaceManagerDatabase.LinkGroupCriterion {
        private LinkGroupCriterionImpl() {
        }

        @Override
        public SpaceManagerDatabase.LinkGroupCriterion whereUpdateTimeAfter(long latestLinkGroupUpdateTime) {
            this.addClause("lastupdatetime >= ?", latestLinkGroupUpdateTime);
            return this;
        }

        @Override
        public SpaceManagerDatabase.LinkGroupCriterion allowsAccessLatency(AccessLatency al) {
            if (al == AccessLatency.NEARLINE) {
                this.addClause("nearlineallowed=1", new Object[0]);
            } else if (al == AccessLatency.ONLINE) {
                this.addClause("onlineallowed=1", new Object[0]);
            }
            return this;
        }

        @Override
        public SpaceManagerDatabase.LinkGroupCriterion allowsRetentionPolicy(RetentionPolicy rp) {
            if (rp == RetentionPolicy.OUTPUT) {
                this.addClause("outputallowed=1", new Object[0]);
            } else if (rp == RetentionPolicy.REPLICA) {
                this.addClause("replicaallowed=1", new Object[0]);
            } else if (rp == RetentionPolicy.CUSTODIAL) {
                this.addClause("custodialallowed=1", new Object[0]);
            }
            return this;
        }

        @Override
        public SpaceManagerDatabase.LinkGroupCriterion whereNameMatches(SqlGlob name) {
            this.whereFieldMatches("name", name);
            return this;
        }

        @Override
        public SpaceManagerDatabase.LinkGroupCriterion hasAvailable(long bytes) {
            this.addClause("availablespaceinbytes >= " + bytes, new Object[0]);
            return this;
        }
    }

    private static class JdbcCriterion {
        final StringBuilder predicate = new StringBuilder();
        final List<Object> arguments = new ArrayList<Object>();

        private JdbcCriterion() {
        }

        protected void addClause(String clause, Object ... arguments) {
            if (this.predicate.length() > 0) {
                this.predicate.append(" AND ");
            }
            this.predicate.append(clause);
            this.arguments.addAll(Arrays.asList(arguments));
        }

        protected void whereFieldMatches(String field, SqlGlob pattern) {
            if (pattern.isGlob()) {
                this.addClause(field + "LIKE ?", pattern.toSql());
            } else {
                this.addClause(field + " = ?", pattern.toString());
            }
        }

        public String getPredicate() {
            return this.predicate.length() == 0 ? "true" : this.predicate.toString();
        }

        public Object[] getArguments() {
            return this.arguments.toArray(new Object[this.arguments.size()]);
        }
    }
}

