/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.LinkGroupAuthorizationRecord;
import diskCacheV111.util.VOInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LinkGroupAuthorizationFile {
    private final Map<String, LinkGroupAuthorizationRecord> records = new HashMap<String, LinkGroupAuthorizationRecord>();
    private static final int OUTSIDE_STATE = 0;
    private static final int LINKGROUP_STATE = 1;
    private static final String COMMENT_KEY = "#";
    private static final String LINKGROUP_KEY = "LinkGroup";

    public LinkGroupAuthorizationFile(File file) throws IOException, ParseException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            this.read(bufferedReader);
        }
    }

    public Collection<LinkGroupAuthorizationRecord> getLinkGroupAuthiorizationRecords() {
        return this.records.values();
    }

    public LinkGroupAuthorizationRecord getLinkGroupAuthorizationRecord(String LinkGroupName) {
        return this.records.get(LinkGroupName);
    }

    public void addLinkGroupAuthiorizationRecord(LinkGroupAuthorizationRecord record) {
        this.records.put(record.getLinkGroupName(), record);
    }

    public void dump(PrintStream out) {
        for (LinkGroupAuthorizationRecord record : this.records.values()) {
            out.println(record.toString());
            out.println();
        }
    }

    private void read(BufferedReader reader) throws IOException, ParseException {
        LinkGroupAuthorizationRecord record;
        String line;
        boolean state = false;
        String linkGroupName = null;
        ArrayList<VOInfo> voinfos = null;
        int icount = 0;
        while ((line = reader.readLine()) != null) {
            ++icount;
            if ((line = line.trim()).startsWith(COMMENT_KEY)) continue;
            if (!state) {
                if (line.length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (!LINKGROUP_KEY.equals(st.nextToken())) {
                    throw new ParseException("line " + icount + "syntax violation: First token must be " + LINKGROUP_KEY, icount);
                }
                state = true;
                linkGroupName = st.nextToken();
                voinfos = new ArrayList<VOInfo>();
                continue;
            }
            if (!state) continue;
            if (line.length() == 0) {
                record = new LinkGroupAuthorizationRecord(linkGroupName, voinfos);
                this.records.put(linkGroupName, record);
                state = false;
                voinfos = null;
                linkGroupName = null;
                continue;
            }
            VOInfo voinfo = new VOInfo(line);
            voinfos.add(voinfo);
        }
        if (state) {
            record = new LinkGroupAuthorizationRecord(linkGroupName, voinfos);
            this.records.put(linkGroupName, record);
        }
    }
}

