/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import com.google.common.base.Throwables;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.services.space.LinkGroupAuthorizationFile;
import diskCacheV111.services.space.LinkGroupAuthorizationRecord;
import diskCacheV111.services.space.SpaceManagerDatabase;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.VOInfo;
import dmg.cells.nucleus.AbstractCellComponent;
import dmg.cells.nucleus.CellCommandListener;
import dmg.util.command.Command;
import dmg.util.command.DelayedCommand;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.dcache.cells.CuratorFrameworkAware;
import org.dcache.poolmanager.PoolLinkGroupInfo;
import org.dcache.poolmanager.RemotePoolMonitor;
import org.dcache.poolmanager.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionException;

public class LinkGroupLoader
extends AbstractCellComponent
implements CellCommandListener,
CuratorFrameworkAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkGroupLoader.class);
    private static final long EAGER_LINKGROUP_UPDATE_PERIOD = 1000L;
    private long updateLinkGroupsPeriod;
    private File authorizationFileName;
    private long latestUpdateTime = System.currentTimeMillis();
    private LinkGroupAuthorizationFile linkGroupAuthorizationFile;
    private long authorizationFileLastUpdateTimestamp;
    private RemotePoolMonitor poolMonitor;
    private SpaceManagerDatabase db;
    private ScheduledExecutorService executor;
    private String zkPath;
    private LeaderLatch leaderLatch;
    private CuratorFramework client;

    @Required
    public void setUpdateLinkGroupsPeriod(long updateLinkGroupsPeriod) {
        this.updateLinkGroupsPeriod = updateLinkGroupsPeriod;
    }

    @Required
    public void setDatabase(SpaceManagerDatabase db) {
        this.db = db;
    }

    @Required
    public void setPoolMonitor(RemotePoolMonitor poolMonitor) {
        this.poolMonitor = poolMonitor;
    }

    @Required
    public void setAuthorizationFileName(File authorizationFileName) {
        this.authorizationFileName = authorizationFileName;
    }

    @Required
    public void setServiceName(String serviceName) {
        this.zkPath = LinkGroupLoader.getZooKeeperLeaderPath(serviceName);
    }

    public long getLatestUpdateTime() {
        return this.latestUpdateTime;
    }

    public void setCuratorFramework(CuratorFramework client) {
        this.client = client;
    }

    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void afterStart() {
        try {
            this.leaderLatch = new LeaderLatch(this.client, this.zkPath, this.getCellAddress().toString());
            this.leaderLatch.addListener((LeaderLatchListener)new LeaderListener());
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void beforeStop() {
        CloseableUtils.closeQuietly((Closeable)this.leaderLatch);
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void getInfo(PrintWriter printWriter) {
        printWriter.append("updateLinkGroupsPeriod = ").println(this.updateLinkGroupsPeriod);
        printWriter.append("authorizationFileName = ").println(this.authorizationFileName);
    }

    private void loadLinkGroupAuthorizationFile() {
        File file = this.authorizationFileName;
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            this.linkGroupAuthorizationFile = null;
        }
        long lastModified = file.lastModified();
        if (this.linkGroupAuthorizationFile == null || lastModified >= this.authorizationFileLastUpdateTimestamp) {
            this.authorizationFileLastUpdateTimestamp = lastModified;
            try {
                this.linkGroupAuthorizationFile = new LinkGroupAuthorizationFile(file);
            }
            catch (IOException | ParseException e) {
                LOGGER.error("Failed to read {}: {}", (Object)file, (Object)e.toString());
            }
        }
    }

    private int updateLinkGroups() throws InterruptedException, RemoteAccessException, DataAccessException, TransactionException {
        long currentTime = System.currentTimeMillis();
        Collection linkGroupInfos = Utils.linkGroupInfos((PoolSelectionUnit)this.poolMonitor.getPoolSelectionUnit(), (CostModule)this.poolMonitor.getCostModule()).values();
        if (!linkGroupInfos.isEmpty()) {
            this.loadLinkGroupAuthorizationFile();
            for (PoolLinkGroupInfo info : linkGroupInfos) {
                this.saveLinkGroup(currentTime, info);
            }
        }
        this.latestUpdateTime = currentTime;
        return linkGroupInfos.size();
    }

    private void saveLinkGroup(long currentTime, PoolLinkGroupInfo info) throws InterruptedException {
        LinkGroupAuthorizationRecord record;
        String linkGroupName = info.getName();
        long avalSpaceInBytes = info.getAvailableSpaceInBytes();
        VOInfo[] vos = null;
        boolean onlineAllowed = info.isOnlineAllowed();
        boolean nearlineAllowed = info.isNearlineAllowed();
        boolean replicaAllowed = info.isReplicaAllowed();
        boolean outputAllowed = info.isOutputAllowed();
        boolean custodialAllowed = info.isCustodialAllowed();
        if (this.linkGroupAuthorizationFile != null && (record = this.linkGroupAuthorizationFile.getLinkGroupAuthorizationRecord(linkGroupName)) != null) {
            vos = record.getVOInfoArray();
        }
        while (true) {
            try {
                this.db.updateLinkGroup(linkGroupName, avalSpaceInBytes, currentTime, onlineAllowed, nearlineAllowed, replicaAllowed, outputAllowed, custodialAllowed, vos);
                break;
            }
            catch (DeadlockLoserDataAccessException e) {
                LOGGER.info("Update of link group {}\u00a0lost deadlock race and will be retried: {}", (Object)linkGroupName, (Object)e.toString());
            }
            catch (RecoverableDataAccessException | TransientDataAccessException | CannotCreateTransactionException e) {
                LOGGER.warn("Update of link group {} failed and will be retried: {}", (Object)linkGroupName, (Object)e.getMessage());
            }
            Thread.sleep(500L);
        }
    }

    private static String getZooKeeperLeaderPath(String serviceName) {
        return ZKPaths.makePath((String)"/dcache/spacemanager", (String)serviceName, (String[])new String[]{"leader"});
    }

    private class LeaderListener
    implements LeaderLatchListener,
    Runnable {
        private ScheduledFuture<?> future;

        private LeaderListener() {
        }

        public synchronized void isLeader() {
            this.future = LinkGroupLoader.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
        }

        public synchronized void notLeader() {
            this.future.cancel(false);
            this.future = null;
        }

        private synchronized void reschedule(long period) {
            if (this.future != null) {
                this.future = LinkGroupLoader.this.executor.schedule(this, period, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long period = 1000L;
            try {
                if (LinkGroupLoader.this.updateLinkGroups() > 0) {
                    period = LinkGroupLoader.this.updateLinkGroupsPeriod;
                }
            }
            catch (DataAccessException | RemoteAccessException | TransactionException e) {
                LOGGER.error("Link group update failed: {}", (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                LOGGER.error("Link group update failed: " + e.toString(), (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.trace("update LinkGroup thread has been interrupted");
            }
            finally {
                this.reschedule(period);
            }
        }
    }

    @Command(name="update link groups", hint="update link group information", description="Link groups are periodically imported from pool manager and stored in the space manager database. This command performs an immediate update of the link group information.")
    public class UpdateLinkGroupsCommand
    extends DelayedCommand<String> {
        public UpdateLinkGroupsCommand() {
            super((Executor)LinkGroupLoader.this.executor);
        }

        protected String execute() throws InterruptedException, DataAccessException, TransactionException, CacheException {
            LinkGroupLoader.this.poolMonitor.refresh();
            int updated = LinkGroupLoader.this.updateLinkGroups();
            return updated + (updated == 1 ? " link group " : " link groups ") + "updated.";
        }
    }
}

