/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceAuthorizationException;
import diskCacheV111.services.space.SpaceManagerAuthorizationPolicy;
import diskCacheV111.util.VOInfo;
import javax.security.auth.Subject;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSpaceManagerAuthorizationPolicy
implements SpaceManagerAuthorizationPolicy {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSpaceManagerAuthorizationPolicy.class);

    @Override
    public void checkReleasePermission(Subject subject, Space space) throws SpaceAuthorizationException {
        String spaceGroup = space.getVoGroup();
        String spaceRole = space.getVoRole();
        if (spaceGroup != null) {
            if (spaceRole == null) {
                if (spaceGroup.equals(Subjects.getUserName((Subject)subject))) {
                    logger.debug("Subject with user name {} has permission to release space {}", (Object)Subjects.getUserName((Subject)subject), (Object)space);
                    return;
                }
                try {
                    long authorisedGid = Long.parseLong(spaceGroup);
                    if (Subjects.hasGid((Subject)subject, (long)authorisedGid)) {
                        logger.debug("Subject with gid {} has permission to release space {}", (Object)authorisedGid, (Object)space);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (FQANPrincipal principal : subject.getPrincipals(FQANPrincipal.class)) {
                FQAN fqan = principal.getFqan();
                if (!spaceGroup.equals(fqan.getGroup()) || spaceRole != null && !spaceRole.equals(fqan.getRole())) continue;
                logger.debug("Subject with fqan {}\u00a0has permission to release space {}", (Object)fqan, (Object)space);
                return;
            }
        }
        throw new SpaceAuthorizationException("Subject " + subject.getPrincipals() + " has no permission to release " + space);
    }

    @Override
    public VOInfo checkReservePermission(Subject subject, LinkGroup linkGroup) throws SpaceAuthorizationException {
        for (VOInfo voInfo : linkGroup.getVOs()) {
            String userName = Subjects.getUserName((Subject)subject);
            if (userName != null && voInfo.match(userName, null)) {
                logger.debug("Subject with user name {} has permission to reserve {}", (Object)userName, (Object)linkGroup);
                return new VOInfo(userName, null);
            }
            for (long gid : Subjects.getGids((Subject)subject)) {
                if (!voInfo.match(Long.toString(gid), null)) continue;
                logger.debug("Subject with gid {} has permission to reserve {}", (Object)gid, (Object)linkGroup);
                return new VOInfo(Long.toString(gid), null);
            }
            Object object = subject.getPrincipals(FQANPrincipal.class).iterator();
            while (object.hasNext()) {
                FQANPrincipal principal = (FQANPrincipal)object.next();
                FQAN fqan = principal.getFqan();
                if (!voInfo.match(fqan.getGroup(), fqan.getRole())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Subject with FQAN {} has permission to reserve {}", (Object)fqan, (Object)linkGroup);
                }
                return new VOInfo(fqan.getGroup(), fqan.getRole());
            }
        }
        throw new SpaceAuthorizationException("Subject " + subject.getPrincipals() + " has no permission to reserve in " + linkGroup);
    }
}

