/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.File;
import diskCacheV111.services.space.FileState;
import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceException;
import diskCacheV111.services.space.SpaceState;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.VOInfo;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.dcache.util.SqlGlob;
import org.springframework.dao.DataAccessException;

@ParametersAreNonnullByDefault
public interface SpaceManagerDatabase {
    public File selectFileForUpdate(PnfsId var1) throws DataAccessException;

    public File selectFileForUpdate(long var1) throws DataAccessException;

    public void removeFile(long var1) throws DataAccessException;

    public void updateFile(File var1) throws DataAccessException;

    public long insertFile(long var1, @Nullable String var3, @Nullable String var4, long var5, @Nullable PnfsId var7, FileState var8) throws DataAccessException, SpaceException;

    public void expire(SpaceCriterion var1);

    public Space insertSpace(@Nullable String var1, @Nullable String var2, RetentionPolicy var3, AccessLatency var4, long var5, long var7, long var9, @Nullable String var11, SpaceState var12, long var13, long var15) throws DataAccessException;

    public Space selectSpaceForUpdate(long var1) throws DataAccessException;

    public Space updateSpace(Space var1) throws DataAccessException;

    public Space getSpace(long var1) throws DataAccessException;

    public long updateLinkGroup(String var1, long var2, long var4, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, VOInfo[] var11) throws DataAccessException;

    public LinkGroup getLinkGroup(long var1) throws DataAccessException;

    public LinkGroup getLinkGroupByName(String var1) throws DataAccessException;

    public File findFile(PnfsId var1) throws DataAccessException;

    public LinkGroupCriterion linkGroups();

    public List<LinkGroup> get(LinkGroupCriterion var1);

    public SpaceCriterion spaces();

    public List<Space> get(SpaceCriterion var1, @Nullable Integer var2);

    public List<Long> getSpaceTokensOf(SpaceCriterion var1);

    public int count(SpaceCriterion var1);

    public int remove(SpaceCriterion var1);

    public FileCriterion files();

    public List<File> get(FileCriterion var1, @Nullable Integer var2);

    public int count(FileCriterion var1);

    public int remove(FileCriterion var1);

    public static interface FileCriterion {
        public FileCriterion whereGroupMatches(SqlGlob var1);

        public FileCriterion whereRoleMatches(SqlGlob var1);

        public FileCriterion whereSpaceTokenIs(Long var1);

        public FileCriterion whereStateIsIn(FileState ... var1);

        public FileCriterion wherePnfsIdIs(PnfsId var1);

        public FileCriterion in(SpaceCriterion var1);

        public FileCriterion whereCreationTimeIsBefore(long var1);
    }

    public static interface SpaceCriterion {
        public SpaceCriterion whereStateIsIn(SpaceState ... var1);

        public SpaceCriterion whereRetentionPolicyIs(RetentionPolicy var1);

        public SpaceCriterion whereAccessLatencyIs(AccessLatency var1);

        public SpaceCriterion whereDescriptionMatches(SqlGlob var1);

        public SpaceCriterion whereRoleMatches(SqlGlob var1);

        public SpaceCriterion whereGroupMatches(SqlGlob var1);

        public SpaceCriterion whereTokenIs(long var1);

        public SpaceCriterion thatNeverExpire();

        public SpaceCriterion whereLinkGroupIs(long var1);

        public SpaceCriterion whereGroupIs(String var1);

        public SpaceCriterion whereRoleIs(String var1);

        public SpaceCriterion whereDescriptionIs(String var1);

        public SpaceCriterion thatExpireBefore(long var1);

        public SpaceCriterion thatHaveNoFiles();
    }

    public static interface LinkGroupCriterion {
        public LinkGroupCriterion whereUpdateTimeAfter(long var1);

        public LinkGroupCriterion allowsAccessLatency(@Nullable AccessLatency var1);

        public LinkGroupCriterion allowsRetentionPolicy(@Nullable RetentionPolicy var1);

        public LinkGroupCriterion whereNameMatches(SqlGlob var1);

        public LinkGroupCriterion hasAvailable(long var1);
    }
}

