/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.services.space.File;
import diskCacheV111.services.space.FileState;
import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.LinkGroupLoader;
import diskCacheV111.services.space.NoFreeSpaceException;
import diskCacheV111.services.space.NoPoolConfiguredSpaceException;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceAuthorizationException;
import diskCacheV111.services.space.SpaceException;
import diskCacheV111.services.space.SpaceManagerAuthorizationPolicy;
import diskCacheV111.services.space.SpaceManagerDatabase;
import diskCacheV111.services.space.SpaceState;
import diskCacheV111.services.space.message.ExtendLifetime;
import diskCacheV111.services.space.message.GetFileSpaceTokensMessage;
import diskCacheV111.services.space.message.GetLinkGroupNamesMessage;
import diskCacheV111.services.space.message.GetLinkGroupsMessage;
import diskCacheV111.services.space.message.GetSpaceMetaData;
import diskCacheV111.services.space.message.GetSpaceTokens;
import diskCacheV111.services.space.message.GetSpaceTokensMessage;
import diskCacheV111.services.space.message.Release;
import diskCacheV111.services.space.message.Reserve;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.util.VOInfo;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsDeleteEntryNotificationMessage;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolFileFlushedMessage;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.AbstractCellComponent;
import dmg.cells.nucleus.CellCommandListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageReceiver;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.Subjects;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.util.BoundedExecutor;
import org.dcache.util.CDCExecutorServiceDecorator;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.transaction.annotation.Transactional;

public final class SpaceManagerService
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpaceManagerService.class);
    private long expireSpaceReservationsPeriod;
    private Thread expireSpaceReservations;
    private boolean shouldDeleteStoredFileRecord;
    private boolean allowUnreservedUploadsToLinkGroups;
    private boolean shouldReturnFlushedSpaceToReservation;
    private boolean isSpaceManagerEnabled;
    private CellPath poolManager;
    private PnfsHandler pnfs;
    private SpaceManagerAuthorizationPolicy authorizationPolicy;
    private ExecutorService executor;
    private PoolMonitor poolMonitor;
    private SpaceManagerDatabase db;
    private LinkGroupLoader linkGroupLoader;
    private long perishedSpacePurgeDelay;
    private int threads;
    private volatile boolean isStopped;

    @Required
    public void setPoolManager(CellPath poolManager) {
        this.poolManager = poolManager;
    }

    @Required
    public void setPnfsHandler(PnfsHandler pnfs) {
        this.pnfs = pnfs;
    }

    @Required
    public void setPoolMonitor(PoolMonitor poolMonitor) {
        this.poolMonitor = poolMonitor;
    }

    @Required
    public void setSpaceManagerEnabled(boolean enabled) {
        this.isSpaceManagerEnabled = enabled;
    }

    @Required
    public void setExpireSpaceReservationsPeriod(long expireSpaceReservationsPeriod) {
        this.expireSpaceReservationsPeriod = expireSpaceReservationsPeriod;
    }

    @Required
    public void setAllowUnreservedUploadsToLinkGroups(boolean allowUnreservedUploadsToLinkGroups) {
        this.allowUnreservedUploadsToLinkGroups = allowUnreservedUploadsToLinkGroups;
    }

    @Required
    public void setShouldDeleteStoredFileRecord(boolean shouldDeleteStoredFileRecord) {
        this.shouldDeleteStoredFileRecord = shouldDeleteStoredFileRecord;
    }

    @Required
    public void setShouldReturnFlushedSpaceToReservation(boolean shouldReturnFlushedSpaceToReservation) {
        this.shouldReturnFlushedSpaceToReservation = shouldReturnFlushedSpaceToReservation;
    }

    @Required
    public void setMaxThreads(int threads) {
        this.threads = threads;
    }

    @Required
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Required
    public void setDatabase(SpaceManagerDatabase db) {
        this.db = db;
    }

    @Required
    public void setAuthorizationPolicy(SpaceManagerAuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    @Required
    public void setLinkGroupLoader(LinkGroupLoader linkGroupLoader) {
        this.linkGroupLoader = linkGroupLoader;
    }

    @Required
    public void setPerishedSpacePurgeDelay(long millis) {
        this.perishedSpacePurgeDelay = millis;
    }

    public void start() {
        this.executor = new CDCExecutorServiceDecorator((ExecutorService)new BoundedExecutor((Executor)this.executor, this.threads));
        this.expireSpaceReservations = new Thread((Runnable)this, "ExpireThreadReservations");
        this.expireSpaceReservations.start();
    }

    public void stop() throws InterruptedException {
        try {
            this.isStopped = true;
            this.executor.shutdown();
            if (this.expireSpaceReservations != null) {
                this.expireSpaceReservations.interrupt();
                this.expireSpaceReservations.join();
            }
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        finally {
            for (Runnable runnable : this.executor.shutdownNow()) {
                this.notifyShutdown(((FibonacciBackoffMessageProcessor)runnable).getEnvelope());
            }
        }
    }

    public void getInfo(PrintWriter printWriter) {
        printWriter.println("isSpaceManagerEnabled=" + this.isSpaceManagerEnabled);
        printWriter.println("expireSpaceReservationsPeriod=" + this.expireSpaceReservationsPeriod);
        printWriter.println("shouldDeleteStoredFileRecord=" + this.shouldDeleteStoredFileRecord);
        printWriter.println("allowUnreservedUploadsToLinkGroups=" + this.allowUnreservedUploadsToLinkGroups);
        printWriter.println("shouldReturnFlushedSpaceToReservation=" + this.shouldReturnFlushedSpaceToReservation);
    }

    private void expireSpaceReservations() throws DataAccessException {
        LOGGER.trace("expireSpaceReservations()...");
        SpaceManagerDatabase.FileCriterion oldTransfers = this.db.files().whereStateIsIn(FileState.TRANSFERRING).whereCreationTimeIsBefore(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L));
        int maximumNumberFilesToLoadAtOnce = 1000;
        for (File file : this.db.get(oldTransfers, (Integer)1000)) {
            try {
                EnumSet<FileAttribute> attributes = EnumSet.of(FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.LOCATIONS, FileAttribute.STORAGEINFO, FileAttribute.ACCESS_LATENCY);
                FileAttributes fileAttributes = this.pnfs.getFileAttributes(file.getPnfsId(), attributes);
                if (fileAttributes.getFileType() != FileType.REGULAR) {
                    this.db.removeFile(file.getId());
                    continue;
                }
                if (fileAttributes.getStorageInfo().isStored()) {
                    boolean isRemovable = !fileAttributes.getAccessLatency().equals((Object)AccessLatency.ONLINE);
                    this.fileFlushed(file.getPnfsId(), fileAttributes.getSize(), isRemovable);
                    continue;
                }
                if (fileAttributes.getLocations().isEmpty()) continue;
                this.transferFinished(file.getPnfsId(), fileAttributes.getSize());
            }
            catch (FileNotFoundCacheException e) {
                this.db.removeFile(file.getId());
            }
            catch (TransientDataAccessException e) {
                LOGGER.warn("Transient data access failure while deleting expired file {}: {}", (Object)file, (Object)e.getMessage());
            }
            catch (DataAccessException e) {
                LOGGER.error("Data access failure while deleting expired file {}: {}", (Object)file, (Object)e.getMessage());
                break;
            }
            catch (TimeoutCacheException e) {
                LOGGER.error("Failed to lookup file {} in name space: {}", (Object)file.getPnfsId(), (Object)e.getMessage());
                break;
            }
            catch (CacheException e) {
                LOGGER.error("Failed to lookup file {} in name space: {}", (Object)file.getPnfsId(), (Object)e.getMessage());
            }
        }
        this.db.expire(this.db.spaces().whereStateIsIn(SpaceState.RESERVED).thatExpireBefore(System.currentTimeMillis()));
        this.db.remove(this.db.files().whereStateIsIn(FileState.STORED, FileState.FLUSHED).in(this.db.spaces().whereStateIsIn(SpaceState.EXPIRED, SpaceState.RELEASED).thatExpireBefore(System.currentTimeMillis() - this.perishedSpacePurgeDelay)));
        this.db.remove(this.db.spaces().whereStateIsIn(SpaceState.EXPIRED, SpaceState.RELEASED).thatHaveNoFiles());
    }

    private void getValidSpaceTokens(GetSpaceTokensMessage msg) throws DataAccessException {
        msg.setSpaceTokenSet(this.db.get(this.db.spaces().thatNeverExpire().whereStateIsIn(SpaceState.RESERVED), null));
    }

    private void getLinkGroups(GetLinkGroupsMessage msg) throws DataAccessException {
        msg.setLinkGroups(this.db.get(this.db.linkGroups()));
    }

    private void getLinkGroupNames(GetLinkGroupNamesMessage msg) throws DataAccessException {
        msg.setLinkGroupNames((Collection)Lists.newArrayList((Iterable)Collections2.transform(this.db.get(this.db.linkGroups()), LinkGroup::getName)));
    }

    private boolean isSpaceManagerMessage(Message message) {
        return message instanceof Reserve || message instanceof GetSpaceTokensMessage || message instanceof GetLinkGroupsMessage || message instanceof GetLinkGroupNamesMessage || message instanceof Release || message instanceof GetSpaceMetaData || message instanceof GetSpaceTokens || message instanceof ExtendLifetime || message instanceof GetFileSpaceTokensMessage;
    }

    private boolean isNotificationMessage(Message message) {
        return message instanceof PoolFileFlushedMessage || message instanceof PnfsDeleteEntryNotificationMessage;
    }

    private boolean isInterceptedMessage(Message message) {
        return message instanceof PoolMgrSelectWritePoolMsg && !message.isReply() || message instanceof DoorTransferFinishedMessage || message instanceof PoolAcceptFileMessage && ((PoolAcceptFileMessage)message).getFileAttributes().getStorageInfo().getKey("LinkGroupId") != null && (!message.isReply() || message.getReturnCode() != 0);
    }

    private boolean isImportantMessage(Message message) {
        return message.isReply() || message instanceof PoolFileFlushedMessage || message instanceof DoorTransferFinishedMessage;
    }

    public void messageArrived(final CellMessage envelope, final Message message) {
        LOGGER.trace("messageArrived : type={} value={} from {}", new Object[]{message.getClass().getName(), message, envelope.getSourcePath()});
        if (!message.isReply()) {
            if (!this.isNotificationMessage(message) && !this.isSpaceManagerMessage(message)) {
                this.messageToForward(envelope, message);
            } else if (this.isSpaceManagerEnabled) {
                this.executor.execute(new FibonacciBackoffMessageProcessor(this.executor, envelope){

                    @Override
                    public void process() throws DeadlockLoserDataAccessException {
                        if (!SpaceManagerService.this.isStopped || SpaceManagerService.this.isImportantMessage(message)) {
                            SpaceManagerService.this.processMessage(message);
                            if (message.getReplyRequired()) {
                                SpaceManagerService.this.returnMessage(envelope);
                            }
                        } else {
                            SpaceManagerService.this.notifyShutdown(envelope);
                        }
                    }
                });
            } else if (message.getReplyRequired()) {
                message.setReply(1, (Serializable)((Object)"Space manager is disabled in configuration"));
                this.returnMessage(envelope);
            }
        }
    }

    public void messageToForward(final CellMessage envelope, final Message message) {
        boolean isEnRouteToDoor;
        LOGGER.trace("messageToForward: type={} value={} from {} going to {}", new Object[]{message.getClass().getName(), message, envelope.getSourcePath(), envelope.getDestinationPath()});
        boolean bl = isEnRouteToDoor = message.isReply() || message instanceof DoorTransferFinishedMessage;
        if (!isEnRouteToDoor) {
            envelope.getDestinationPath().insert(this.poolManager);
        }
        if (envelope.nextDestination()) {
            if (this.isSpaceManagerEnabled && this.isInterceptedMessage(message)) {
                this.executor.execute(new FibonacciBackoffMessageProcessor(this.executor, envelope){

                    @Override
                    public void process() throws DeadlockLoserDataAccessException {
                        if (!SpaceManagerService.this.isStopped || SpaceManagerService.this.isImportantMessage(message)) {
                            SpaceManagerService.this.processMessage(message);
                            if (message.getReturnCode() != 0 && !isEnRouteToDoor) {
                                envelope.revertDirection();
                            }
                        } else {
                            SpaceManagerService.this.notifyShutdown(envelope);
                        }
                        SpaceManagerService.this.forwardMessage(envelope, isEnRouteToDoor);
                    }
                });
            } else {
                this.forwardMessage(envelope, isEnRouteToDoor);
            }
        }
    }

    private void notifyShutdown(CellMessage envelope) {
        envelope.setMessageObject((Serializable)new NoRouteToCellException(envelope, "Space manager is shutting down."));
        this.returnMessage(envelope);
    }

    private void returnMessage(CellMessage envelope) {
        envelope.revertDirection();
        this.sendMessage(envelope);
    }

    private void forwardMessage(CellMessage envelope, boolean isEnRouteToDoor) {
        this.sendMessage(envelope);
    }

    private void processMessage(Message message) throws DeadlockLoserDataAccessException {
        try {
            boolean isSuccessful = false;
            int attempts = 0;
            while (!isSuccessful) {
                try {
                    this.processMessageTransactionally(message);
                    isSuccessful = true;
                }
                catch (DeadlockLoserDataAccessException e) {
                    LOGGER.debug("Transaction lost deadlock race and will be retried: {}", (Object)e.getMessage());
                    throw e;
                }
                catch (RecoverableDataAccessException | TransientDataAccessException e) {
                    if (attempts >= 3) {
                        throw e;
                    }
                    LOGGER.warn("Retriable data access error: {}", (Object)e.toString());
                    ++attempts;
                }
            }
        }
        catch (SpaceAuthorizationException e) {
            message.setFailedConditionally(10018, (Serializable)e);
        }
        catch (NoPoolConfiguredSpaceException e) {
            message.setFailed(10024, (Serializable)((Object)e.getMessage()));
        }
        catch (NoFreeSpaceException e) {
            message.setFailedConditionally(10017, (Serializable)e);
        }
        catch (SpaceException e) {
            message.setFailedConditionally(10015, (Serializable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Message processing failed: {}", (Object)e.getMessage(), (Object)e);
            message.setFailedConditionally(10015, (Serializable)((Object)e.getMessage()));
        }
        catch (DeadlockLoserDataAccessException e) {
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("Message processing failed: {}", (Object)e.toString());
            message.setFailedConditionally(10011, (Serializable)((Object)"Internal failure during space management"));
        }
        catch (RuntimeException e) {
            LOGGER.error("Message processing failed: {}", (Object)e.getMessage(), (Object)e);
            message.setFailedConditionally(10011, (Serializable)((Object)"Internal failure during space management"));
        }
    }

    @Transactional(rollbackFor={SpaceException.class})
    private void processMessageTransactionally(Message message) throws SpaceException {
        if (message instanceof PoolMgrSelectWritePoolMsg) {
            this.selectPool((PoolMgrSelectWritePoolMsg)message);
        } else if (message instanceof PoolAcceptFileMessage) {
            PoolAcceptFileMessage poolRequest = (PoolAcceptFileMessage)message;
            if (message.isReply()) {
                this.transferStarted(poolRequest.getPnfsId(), poolRequest.getReturnCode() == 0);
            } else {
                this.transferStarting(poolRequest);
            }
        } else if (message instanceof DoorTransferFinishedMessage) {
            this.transferFinished((DoorTransferFinishedMessage)message);
        } else if (message instanceof Reserve) {
            this.reserveSpace((Reserve)message);
        } else if (message instanceof GetSpaceTokensMessage) {
            this.getValidSpaceTokens((GetSpaceTokensMessage)message);
        } else if (message instanceof GetLinkGroupsMessage) {
            this.getLinkGroups((GetLinkGroupsMessage)message);
        } else if (message instanceof GetLinkGroupNamesMessage) {
            this.getLinkGroupNames((GetLinkGroupNamesMessage)message);
        } else if (message instanceof Release) {
            this.releaseSpace((Release)message);
        } else if (message instanceof GetSpaceMetaData) {
            this.getSpaceMetaData((GetSpaceMetaData)message);
        } else if (message instanceof GetSpaceTokens) {
            this.getSpaceTokens((GetSpaceTokens)message);
        } else if (message instanceof ExtendLifetime) {
            this.extendLifetime((ExtendLifetime)message);
        } else if (message instanceof PoolFileFlushedMessage) {
            this.fileFlushed((PoolFileFlushedMessage)message);
        } else if (message instanceof GetFileSpaceTokensMessage) {
            this.getFileSpaceTokens((GetFileSpaceTokensMessage)message);
        } else if (message instanceof PnfsDeleteEntryNotificationMessage) {
            this.namespaceEntryDeleted((PnfsDeleteEntryNotificationMessage)message);
        } else {
            throw new RuntimeException("Unexpected " + message.getClass() + ": Please report this to support@dcache.org");
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    this.expireSpaceReservations();
                }
                catch (DeadlockLoserDataAccessException e) {
                    LOGGER.debug("Expiration failed: {}", (Object)e.getMessage());
                }
                catch (TransientDataAccessException e) {
                    LOGGER.warn("Expiration failed: {}", (Object)e.getMessage());
                }
                catch (DataAccessException e) {
                    LOGGER.error("Expiration failed: {}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Expiration failed: {}", (Object)e.toString());
                }
                Thread.sleep(this.expireSpaceReservationsPeriod);
            }
        }
        catch (InterruptedException e) {
            LOGGER.trace("Expiration thread has terminated.");
            return;
        }
    }

    private void releaseSpace(Release release) throws DataAccessException, SpaceException {
        LOGGER.trace("releaseSpace({})", (Object)release);
        long spaceToken = release.getSpaceToken();
        Long spaceToReleaseInBytes = release.getReleaseSizeInBytes();
        if (spaceToReleaseInBytes != null) {
            throw new UnsupportedOperationException("partial release is not supported yet");
        }
        Space space = this.db.selectSpaceForUpdate(spaceToken);
        if (space.getState() == SpaceState.RELEASED) {
            throw new EmptyResultDataAccessException("Space reservation " + spaceToken + " was already released.", 1);
        }
        Subject subject = release.getSubject();
        this.authorizationPolicy.checkReleasePermission(subject, space);
        space.setState(SpaceState.RELEASED);
        this.db.updateSpace(space);
    }

    private void reserveSpace(Reserve reserve) throws DataAccessException, SpaceException {
        Space space = this.reserveSpace(reserve.getSubject(), reserve.getSizeInBytes(), reserve.getAccessLatency(), reserve.getRetentionPolicy(), reserve.getLifetime(), reserve.getDescription());
        reserve.setSpaceToken(space.getId());
    }

    private void transferStarting(PoolAcceptFileMessage message) throws DataAccessException, SpaceException {
        long spaceId;
        LOGGER.trace("transferStarting({})", (Object)message);
        PnfsId pnfsId = (PnfsId)Preconditions.checkNotNull((Object)message.getPnfsId());
        FileAttributes fileAttributes = message.getFileAttributes();
        VOInfo owner = this.getVoInfo(message.getSubject());
        long sizeInBytes = message.getPreallocated();
        String spaceToken = fileAttributes.getStorageInfo().getKey("SpaceToken");
        if (spaceToken != null) {
            spaceId = Long.parseLong(spaceToken);
        } else {
            LOGGER.trace("transferStarting: file is not found, no prior reservations for this file");
            long lifetime = 3600000L;
            String description = null;
            long linkGroupId = Long.parseLong(fileAttributes.getStorageInfo().getKey("LinkGroupId"));
            Space space = this.db.insertSpace(owner.getVoGroup(), owner.getVoRole(), fileAttributes.getRetentionPolicy(), fileAttributes.getAccessLatency(), linkGroupId, sizeInBytes, lifetime, description, SpaceState.RESERVED, 0L, 0L);
            spaceId = space.getId();
        }
        this.db.insertFile(spaceId, owner.getVoGroup(), owner.getVoRole(), sizeInBytes, pnfsId, FileState.TRANSFERRING);
    }

    private void transferStarted(PnfsId pnfsId, boolean success) throws DataAccessException {
        LOGGER.trace("transferStarted({},{})", (Object)pnfsId, (Object)success);
        if (!success) {
            this.db.remove(this.db.files().wherePnfsIdIs(pnfsId).whereStateIsIn(FileState.TRANSFERRING));
        }
    }

    private void transferFinished(DoorTransferFinishedMessage finished) throws DataAccessException {
        if (finished.getReturnCode() == 10001) {
            this.fileRemoved(finished.getPnfsId());
        } else {
            this.transferFinished(finished.getPnfsId(), finished.getFileAttributes().getSize());
        }
    }

    @Transactional
    private void transferFinished(PnfsId pnfsId, long size) throws DataAccessException {
        File f;
        LOGGER.trace("transferFinished({})", (Object)pnfsId);
        try {
            f = this.db.selectFileForUpdate(pnfsId);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.trace("failed to find file {}: {}", (Object)pnfsId, (Object)e.getMessage());
            return;
        }
        if (f.getState() != FileState.TRANSFERRING) {
            LOGGER.trace("transferFinished({}): file state={}", (Object)pnfsId, (Object)f.getState());
        } else if (this.shouldDeleteStoredFileRecord) {
            LOGGER.trace("file transferred, deleting file record");
            this.db.removeFile(f.getId());
        } else {
            f.setSizeInBytes(size);
            f.setState(FileState.STORED);
            this.db.updateFile(f);
        }
    }

    private void fileFlushed(PoolFileFlushedMessage fileFlushed) throws DataAccessException {
        FileAttributes fileAttributes = fileFlushed.getFileAttributes();
        boolean isRemovable = !fileAttributes.getAccessLatency().equals((Object)AccessLatency.ONLINE);
        this.fileFlushed(fileFlushed.getPnfsId(), fileAttributes.getSize(), isRemovable);
    }

    @Transactional
    private void fileFlushed(PnfsId pnfsId, long size, boolean isRemovable) throws DataAccessException {
        File f;
        LOGGER.trace("fileFlushed({})", (Object)pnfsId);
        try {
            f = this.db.selectFileForUpdate(pnfsId);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.trace("failed to find file {}: {}", (Object)pnfsId, (Object)e.getMessage());
            return;
        }
        if (this.shouldDeleteStoredFileRecord) {
            this.db.removeFile(f.getId());
        } else if (f.getState() != FileState.FLUSHED) {
            if (this.shouldReturnFlushedSpaceToReservation && isRemovable) {
                f.setSizeInBytes(size);
                f.setState(FileState.FLUSHED);
                this.db.updateFile(f);
            } else if (f.getState() == FileState.TRANSFERRING) {
                f.setSizeInBytes(size);
                f.setState(FileState.STORED);
                this.db.updateFile(f);
            }
        }
    }

    @Transactional
    private void fileRemoved(PnfsId pnfsId) {
        LOGGER.trace("fileRemoved({})", (Object)pnfsId);
        this.db.remove(this.db.files().wherePnfsIdIs(pnfsId));
    }

    private Space reserveSpace(Subject subject, long sizeInBytes, AccessLatency latency, RetentionPolicy policy, long lifetime, String description) throws DataAccessException, SpaceException {
        LOGGER.trace("reserveSpace(subject={}, sz={}, latency={}, policy={}, lifetime={}, description={})", new Object[]{subject.getPrincipals(), sizeInBytes, latency, policy, lifetime, description});
        List linkGroups = this.db.get(this.db.linkGroups().allowsAccessLatency(latency).allowsRetentionPolicy(policy).hasAvailable(sizeInBytes).whereUpdateTimeAfter(this.linkGroupLoader.getLatestUpdateTime())).stream().sorted(Comparator.comparing(LinkGroup::getAvailableSpace).reversed()).collect(Collectors.toList());
        if (linkGroups.isEmpty()) {
            LOGGER.warn("Failed to find matching linkgroup for reservation request.");
            throw new NoFreeSpaceException("No space available.");
        }
        for (LinkGroup lg : linkGroups) {
            try {
                VOInfo voInfo = this.authorizationPolicy.checkReservePermission(subject, lg);
                if (latency == null) {
                    if (policy == RetentionPolicy.CUSTODIAL) {
                        if (lg.isNearlineAllowed()) {
                            latency = AccessLatency.NEARLINE;
                        } else {
                            if (!lg.isOnlineAllowed()) continue;
                            latency = AccessLatency.ONLINE;
                        }
                    } else if (lg.isOnlineAllowed()) {
                        latency = AccessLatency.ONLINE;
                    } else {
                        if (!lg.isNearlineAllowed()) continue;
                        latency = AccessLatency.NEARLINE;
                    }
                }
                LOGGER.trace("Chose linkgroup {}", (Object)lg);
                return this.db.insertSpace(voInfo.getVoGroup(), voInfo.getVoRole(), policy, latency, lg.getId(), sizeInBytes, lifetime, description, SpaceState.RESERVED, 0L, 0L);
            }
            catch (SpaceAuthorizationException spaceAuthorizationException) {
            }
        }
        LOGGER.warn("Failed to find linkgroup where user is authorized to reserve space.");
        throw new SpaceAuthorizationException("Failed to find LinkGroup where user is authorized to reserve space.");
    }

    @Nullable
    private LinkGroup findLinkGroupForWrite(Subject subject, ProtocolInfo protocolInfo, FileAttributes fileAttributes, long size) throws DataAccessException, SpaceException {
        boolean hasIdentity = subject.getPrincipals().stream().anyMatch(p -> p instanceof FQANPrincipal || p instanceof UserNamePrincipal || p instanceof GidPrincipal);
        if (!hasIdentity) {
            if (this.isWriteableOutsideLinkgroup(protocolInfo, fileAttributes)) {
                return null;
            }
            throw new SpaceAuthorizationException("Unable to reserve space: user has no FQAN or username.");
        }
        List linkGroups = this.db.get(this.db.linkGroups().allowsAccessLatency(fileAttributes.getAccessLatency()).allowsRetentionPolicy(fileAttributes.getRetentionPolicy()).hasAvailable(size).whereUpdateTimeAfter(this.linkGroupLoader.getLatestUpdateTime())).stream().sorted(Comparator.comparing(LinkGroup::getAvailableSpace).reversed()).collect(Collectors.toList());
        if (linkGroups.isEmpty()) {
            if (this.isWriteableOutsideLinkgroup(protocolInfo, fileAttributes)) {
                return null;
            }
            throw new NoPoolConfiguredSpaceException("Unable to reserve space: no linkgroups configured.");
        }
        ArrayList<String> linkGroupNames = new ArrayList<String>();
        for (LinkGroup linkGroup : linkGroups) {
            try {
                this.authorizationPolicy.checkReservePermission(subject, linkGroup);
                linkGroupNames.add(linkGroup.getName());
            }
            catch (SpaceAuthorizationException spaceAuthorizationException) {}
        }
        if (linkGroupNames.isEmpty()) {
            if (this.isWriteableOutsideLinkgroup(protocolInfo, fileAttributes)) {
                return null;
            }
            throw new SpaceAuthorizationException("Unable to reserve space: user not authorized to reserve space in any linkgroup.");
        }
        String linkGroupName = this.findLinkGroupForWrite(protocolInfo, fileAttributes, linkGroupNames);
        LOGGER.trace("Found {} linkgroups protocolInfo={}, fileAttributes={}", new Object[]{linkGroups.size(), protocolInfo, fileAttributes});
        if (linkGroupName == null) {
            if (this.isWriteableOutsideLinkgroup(protocolInfo, fileAttributes)) {
                return null;
            }
            String hostName = protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)protocolInfo).getSocketAddress().getAddress().getHostAddress() : null;
            String protocol = protocolInfo.getProtocol() + '/' + protocolInfo.getMajorVersion();
            throw new NoPoolConfiguredSpaceException("Unable to reserve space: no write link in linkgroups " + linkGroupNames + " for " + "writing a file with [net=" + hostName + ",protocol=" + protocol + ",store=" + fileAttributes.getStorageClass() + "@" + fileAttributes.getHsm() + ",cache=" + Strings.nullToEmpty((String)fileAttributes.getCacheClass()) + "]");
        }
        for (LinkGroup lg : linkGroups) {
            if (!lg.getName().equals(linkGroupName)) continue;
            return lg;
        }
        throw new IllegalStateException("Unable to reserve space for upload: failed to find linkgroup " + linkGroupName + ".");
    }

    @Nullable
    private String findLinkGroupForWrite(ProtocolInfo protocolInfo, FileAttributes fileAttributes, Iterable<String> linkGroups) {
        String protocol = protocolInfo.getProtocol() + '/' + protocolInfo.getMajorVersion();
        String hostName = protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)protocolInfo).getSocketAddress().getAddress().getHostAddress() : null;
        for (String linkGroup : linkGroups) {
            PoolPreferenceLevel[] levels = this.poolMonitor.getPoolSelectionUnit().match(PoolSelectionUnit.DirectionType.WRITE, hostName, protocol, fileAttributes, linkGroup);
            if (levels.length <= 0) continue;
            return linkGroup;
        }
        return null;
    }

    private boolean isWriteableOutsideLinkgroup(ProtocolInfo info, FileAttributes attributes) throws NoFreeSpaceException {
        String protocol = info.getProtocol() + '/' + info.getMajorVersion();
        String hostname = info instanceof IpProtocolInfo ? ((IpProtocolInfo)info).getSocketAddress().getAddress().getHostAddress() : null;
        PoolPreferenceLevel[] levels = this.poolMonitor.getPoolSelectionUnit().match(PoolSelectionUnit.DirectionType.WRITE, hostname, protocol, attributes, null);
        return levels.length != 0;
    }

    private VOInfo getVoInfo(Subject subject) {
        String effectiveRole;
        String effectiveGroup;
        FQAN primaryFqan = Subjects.getPrimaryFqan((Subject)subject);
        String username = Subjects.getUserName((Subject)subject);
        if (primaryFqan != null) {
            effectiveGroup = primaryFqan.getGroup();
            effectiveRole = primaryFqan.getRole();
        } else if (username != null) {
            effectiveGroup = Subjects.getUserName((Subject)subject);
            effectiveRole = null;
        } else {
            effectiveGroup = Long.toString(Subjects.getPrimaryGid((Subject)subject));
            effectiveRole = null;
        }
        return new VOInfo(effectiveGroup, effectiveRole);
    }

    private void selectPool(PoolMgrSelectWritePoolMsg selectWritePool) throws DataAccessException, SpaceException {
        LOGGER.trace("selectPool({})", (Object)selectWritePool);
        FileAttributes fileAttributes = selectWritePool.getFileAttributes();
        String defaultSpaceToken = (String)fileAttributes.getStorageInfo().getMap().get("writeToken");
        Subject subject = selectWritePool.getSubject();
        if (defaultSpaceToken != null) {
            Space space;
            LOGGER.trace("selectPool: file is not found, found default space token, calling insertFile()");
            try {
                space = this.db.getSpace(Long.parseLong(defaultSpaceToken));
            }
            catch (NumberFormatException | EmptyResultDataAccessException e) {
                throw new IllegalArgumentException("No such space reservation: " + defaultSpaceToken);
            }
            LinkGroup linkGroup = this.db.getLinkGroup(space.getLinkGroupId());
            String linkGroupName = linkGroup.getName();
            selectWritePool.setLinkGroup(linkGroupName);
            StorageInfo storageInfo = selectWritePool.getStorageInfo();
            storageInfo.setKey("SpaceToken", Long.toString(space.getId()));
            storageInfo.setKey("LinkGroupId", Long.toString(linkGroup.getId()));
            if (!fileAttributes.isDefined(FileAttribute.ACCESS_LATENCY)) {
                fileAttributes.setAccessLatency(space.getAccessLatency());
            } else if (fileAttributes.getAccessLatency() != space.getAccessLatency()) {
                throw new SpaceException("Access latency conflicts with access latency defined by space reservation.");
            }
            if (!fileAttributes.isDefined(FileAttribute.RETENTION_POLICY)) {
                fileAttributes.setRetentionPolicy(space.getRetentionPolicy());
            } else if (fileAttributes.getRetentionPolicy() != space.getRetentionPolicy()) {
                throw new SpaceException("Retention policy conflicts with retention policy defined by space reservation.");
            }
            if (space.getDescription() != null) {
                storageInfo.setKey("SpaceTokenDescription", space.getDescription());
            }
            LOGGER.trace("selectPool: found linkGroup = {}, forwarding message", (Object)linkGroupName);
        } else if (this.allowUnreservedUploadsToLinkGroups) {
            LOGGER.trace("Upload outside a reservation, identifying appropriate linkgroup");
            LinkGroup linkGroup = this.findLinkGroupForWrite(subject, selectWritePool.getProtocolInfo(), fileAttributes, selectWritePool.getPreallocated());
            if (linkGroup != null) {
                String linkGroupName = linkGroup.getName();
                selectWritePool.setLinkGroup(linkGroupName);
                fileAttributes.getStorageInfo().setKey("LinkGroupId", Long.toString(linkGroup.getId()));
                LOGGER.trace("selectPool: found linkGroup = {}, forwarding message", (Object)linkGroupName);
            }
        } else if (this.isWriteableOutsideLinkgroup(selectWritePool.getProtocolInfo(), fileAttributes)) {
            LOGGER.debug("Upload proceeding outside of any linkgroup.");
        } else {
            throw new NoPoolConfiguredSpaceException("No write pools configured outside of a linkgroup.");
        }
    }

    private void namespaceEntryDeleted(PnfsDeleteEntryNotificationMessage msg) throws DataAccessException {
        this.fileRemoved(msg.getPnfsId());
    }

    private void getSpaceMetaData(GetSpaceMetaData gsmd) throws IllegalArgumentException {
        String[] tokens = gsmd.getSpaceTokens();
        if (tokens == null) {
            throw new IllegalArgumentException("null space tokens");
        }
        Space[] spaces = new Space[tokens.length];
        for (int i = 0; i < spaces.length; ++i) {
            try {
                Long expirationTime;
                Space space = this.db.getSpace(Long.parseLong(tokens[i]));
                if (space.getState().equals((Object)SpaceState.RESERVED) && (expirationTime = space.getExpirationTime()) != null && expirationTime <= System.currentTimeMillis()) {
                    space.setState(SpaceState.EXPIRED);
                }
                spaces[i] = space;
                continue;
            }
            catch (NumberFormatException space) {
                continue;
            }
            catch (EmptyResultDataAccessException e) {
                LOGGER.error("failed to find space reservation {}: {}", (Object)tokens[i], (Object)e.getMessage());
            }
        }
        gsmd.setSpaces(spaces);
    }

    private void getSpaceTokens(GetSpaceTokens gst) throws DataAccessException {
        String description = gst.getDescription();
        Subject subject = gst.getSubject();
        HashSet<Long> spaces = new HashSet<Long>();
        if (description == null) {
            for (FQAN fqan : Subjects.getFqans((Subject)subject)) {
                String role = fqan.getRole();
                SpaceManagerDatabase.SpaceCriterion criterion = this.db.spaces().whereStateIsIn(SpaceState.RESERVED).whereGroupIs(fqan.getGroup());
                if (!Strings.isNullOrEmpty((String)role)) {
                    criterion.whereRoleIs(role);
                }
                spaces.addAll(this.db.getSpaceTokensOf(criterion));
            }
            spaces.addAll(this.db.getSpaceTokensOf(this.db.spaces().whereStateIsIn(SpaceState.RESERVED).whereGroupIs(Subjects.getUserName((Subject)subject))));
        } else {
            spaces.addAll(this.db.getSpaceTokensOf(this.db.spaces().whereStateIsIn(SpaceState.RESERVED).whereDescriptionIs(description)));
        }
        gst.setSpaceToken(Longs.toArray(spaces));
    }

    private void getFileSpaceTokens(GetFileSpaceTokensMessage getFileTokens) throws DataAccessException {
        PnfsId pnfsId = getFileTokens.getPnfsId();
        List<File> files = this.db.get(this.db.files().wherePnfsIdIs(pnfsId), null);
        getFileTokens.setSpaceToken(Longs.toArray((Collection)Collections2.transform(files, File::getSpaceId)));
    }

    private void extendLifetime(ExtendLifetime extendLifetime) throws DataAccessException {
        long token = extendLifetime.getSpaceToken();
        long newLifetime = extendLifetime.getNewLifetime();
        Space space = this.db.selectSpaceForUpdate(token);
        if (space.getState().isFinal()) {
            throw new DataIntegrityViolationException("Space reservation was already released.");
        }
        Long oldExpirationTime = space.getExpirationTime();
        if (oldExpirationTime != null) {
            if (newLifetime == -1L) {
                space.setExpirationTime(null);
                this.db.updateSpace(space);
                return;
            }
            long newExpirationTime = System.currentTimeMillis() + newLifetime;
            if (newExpirationTime > oldExpirationTime) {
                space.setExpirationTime(Long.valueOf(newExpirationTime));
                this.db.updateSpace(space);
            }
        }
    }

    private abstract class FibonacciBackoffMessageProcessor
    implements Runnable {
        private final CellMessage envelope;
        private final Executor executor;
        private long previous = 0L;
        private long current = 1L;

        public FibonacciBackoffMessageProcessor(Executor executor, CellMessage envelope) {
            this.executor = executor;
            this.envelope = envelope;
        }

        public CellMessage getEnvelope() {
            return this.envelope;
        }

        protected abstract void process() throws Exception;

        public long next() {
            long next = this.current + this.previous;
            this.previous = this.current;
            this.current = next;
            return this.previous;
        }

        @Override
        public void run() {
            try {
                try {
                    if (this.envelope.getLocalAge() > this.envelope.getAdjustedTtl()) {
                        LOGGER.warn("Discarding {} because its age of {} ms exceeds its time to live of {} ms.", new Object[]{this.envelope.getMessageObject().getClass().getSimpleName(), this.envelope.getLocalAge(), this.envelope.getAdjustedTtl()});
                    } else {
                        this.process();
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    long delay = (long)(Math.random() * (double)this.next());
                    LOGGER.info("Request processing failed ({}) and will sleep for {} ms.", (Object)e.toString(), (Object)delay);
                    Thread.sleep(delay);
                    this.executor.execute(this);
                }
            }
            catch (InterruptedException e) {
                SpaceManagerService.this.notifyShutdown(this.envelope);
            }
        }
    }
}

