/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.repository;

import diskCacheV111.util.PnfsId;
import java.io.Serializable;

public class CacheRepositoryEntryInfo
implements Serializable {
    private static final long serialVersionUID = -4494188511917602601L;
    public static final int PRECIOUS_BIT = 0;
    public static final int CACHED_BIT = 1;
    public static final int RECEIVINGFROMCLIENT_BIT = 2;
    public static final int RECEIVINGFROMSTORE_BIT = 3;
    public static final int SENDINGTOSTORE_BIT = 4;
    public static final int BAD_BIT = 5;
    public static final int REMOVED_BIT = 6;
    public static final int DESTROYED_BIT = 7;
    public static final int STICKY_BIT = 8;
    private final PnfsId pnfsId;
    private final int bitmask;
    private final long lastAccessTime;
    private final long creationTime;
    private final long size;

    public CacheRepositoryEntryInfo(PnfsId pnfsId, int bitmask, long lastAccessTime, long creationTime, long size) {
        this.pnfsId = pnfsId;
        this.bitmask = bitmask;
        this.lastAccessTime = lastAccessTime;
        this.creationTime = creationTime;
        this.size = size;
    }

    private boolean getBit(int bitnum) {
        return (this.bitmask & 1 << bitnum) != 0;
    }

    public int getBitMask() {
        return this.bitmask;
    }

    public boolean isPrecious() {
        return this.getBit(0);
    }

    public boolean isCached() {
        return this.getBit(1);
    }

    public boolean isReceivingFromClient() {
        return this.getBit(2);
    }

    public boolean isReceivingFromStore() {
        return this.getBit(3);
    }

    public boolean isBad() {
        return this.getBit(5);
    }

    public boolean isRemoved() {
        return this.getBit(6);
    }

    public boolean isDestroyed() {
        return this.getBit(7);
    }

    public boolean isSticky() {
        return this.getBit(8);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public PnfsId getPnfsId() {
        return this.pnfsId;
    }

    public long getSize() {
        return this.size;
    }
}

