/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.VOInfo;
import java.io.Serializable;
import java.util.Date;

public class LinkGroup
implements Serializable {
    private static final long serialVersionUID = -7606565102712000875L;
    private long id;
    private String name;
    private long availableSpace;
    private boolean onlineAllowed;
    private boolean nearlineAllowed;
    private boolean replicaAllowed;
    private boolean outputAllowed;
    private boolean custodialAllowed;
    private VOInfo[] vos;
    private long updateTime;
    private long reservedSpace;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getFreeSpace() {
        return this.reservedSpace + this.availableSpace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(' ');
        sb.append("Name:").append(this.name).append(' ');
        sb.append("AvailableSpace:").append(this.availableSpace).append(' ');
        sb.append("ReservedSpace:").append(this.reservedSpace).append(' ');
        sb.append("AvailableSpace:").append(this.getAvailableSpace()).append(' ');
        sb.append("VOs:");
        for (VOInfo vo : this.vos) {
            sb.append('{').append(vo).append('}');
        }
        sb.append(' ');
        sb.append("onlineAllowed:").append(this.onlineAllowed).append(' ');
        sb.append("nearlineAllowed:").append(this.nearlineAllowed).append(' ');
        sb.append("replicaAllowed:").append(this.replicaAllowed).append(' ');
        sb.append("custodialAllowed:").append(this.custodialAllowed).append(' ');
        sb.append("outputAllowed:").append(this.outputAllowed).append(' ');
        sb.append("UpdateTime:").append(new Date(this.updateTime).toString()).append("(").append(this.updateTime).append(")");
        return sb.toString();
    }

    public VOInfo[] getVOs() {
        return this.vos;
    }

    public void setVOs(VOInfo[] vos) {
        this.vos = vos;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public boolean isOnlineAllowed() {
        return this.onlineAllowed;
    }

    public void setOnlineAllowed(boolean onlineAllowed) {
        this.onlineAllowed = onlineAllowed;
    }

    public boolean isNearlineAllowed() {
        return this.nearlineAllowed;
    }

    public void setNearlineAllowed(boolean nearlineAllowed) {
        this.nearlineAllowed = nearlineAllowed;
    }

    public boolean isReplicaAllowed() {
        return this.replicaAllowed;
    }

    public void setReplicaAllowed(boolean replicaAllowed) {
        this.replicaAllowed = replicaAllowed;
    }

    public boolean isOutputAllowed() {
        return this.outputAllowed;
    }

    public void setOutputAllowed(boolean outputAllowed) {
        this.outputAllowed = outputAllowed;
    }

    public boolean isCustodialAllowed() {
        return this.custodialAllowed;
    }

    public void setCustodialAllowed(boolean custodialAllowed) {
        this.custodialAllowed = custodialAllowed;
    }

    public long getReservedSpace() {
        return this.reservedSpace;
    }

    public void setReservedSpace(long reserved) {
        this.reservedSpace = reserved;
    }

    public void setAvailableSpace(long availableSpace) {
        this.availableSpace = availableSpace;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public boolean isAllowed(AccessLatency al) {
        return al == AccessLatency.NEARLINE && this.isNearlineAllowed() || al == AccessLatency.ONLINE && this.isOnlineAllowed();
    }

    public boolean isAllowed(RetentionPolicy rp) {
        return rp == RetentionPolicy.CUSTODIAL && this.isCustodialAllowed() || rp == RetentionPolicy.REPLICA && this.isReplicaAllowed() || rp == RetentionPolicy.OUTPUT && this.isOutputAllowed();
    }
}

