/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.SpaceState;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import java.io.Serializable;
import java.util.Date;

public class Space
implements Serializable {
    private static final long serialVersionUID = -1935368561781812540L;
    private final long id;
    private String voGroup;
    private String voRole;
    private RetentionPolicy retentionPolicy;
    private AccessLatency accessLatency;
    private long linkGroupId;
    private long sizeInBytes;
    private long usedSizeInBytes;
    private long allocatedSpaceInBytes;
    private long creationTime;
    private Long expirationTime;
    private String description;
    private SpaceState state;

    public Space(long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long creationTime, Long expirationTime, String description, SpaceState state, long used, long allocated) {
        this.id = id;
        this.voGroup = voGroup;
        this.voRole = voRole;
        this.retentionPolicy = retentionPolicy;
        this.accessLatency = accessLatency;
        this.linkGroupId = linkGroupId;
        this.sizeInBytes = sizeInBytes;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.description = description;
        this.state = state;
        this.usedSizeInBytes = used;
        this.allocatedSpaceInBytes = allocated;
    }

    public long getId() {
        return this.id;
    }

    public long getLinkGroupId() {
        return this.linkGroupId;
    }

    public void setLinkGroupId(long linkGroupId) {
        this.linkGroupId = linkGroupId;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(long sizeInBytes) {
        long usedSpace = this.getUsedSizeInBytes() + this.getAllocatedSpaceInBytes();
        if (sizeInBytes < usedSpace) {
            throw new IllegalStateException("Cannot downsize space reservation below " + usedSpace + " bytes, release files first.");
        }
        this.sizeInBytes = sizeInBytes;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SpaceState getState() {
        return this.state;
    }

    public void setState(SpaceState state) {
        if (this.state.isFinal()) {
            throw new IllegalStateException("Change from " + (Object)((Object)this.state) + " to " + (Object)((Object)state) + " is not allowed.");
        }
        this.state = state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(' ');
        sb.append("voGroup:").append(this.voGroup).append(' ');
        sb.append("voRole:").append(this.voRole).append(' ');
        sb.append("retentionPolicy:").append(this.retentionPolicy.toString()).append(' ');
        sb.append("accessLatency:").append(this.accessLatency.toString()).append(' ');
        sb.append("linkGroupId:").append(this.linkGroupId).append(' ');
        sb.append("size:").append(this.sizeInBytes).append(' ');
        sb.append("created:").append(new Date(this.creationTime)).append(' ');
        sb.append("lifetime:").append(this.expirationTime == null ? -1L : this.expirationTime - this.creationTime).append("ms ");
        sb.append("expiration:").append(this.expirationTime == null ? "NEVER" : new Date(this.expirationTime)).append(' ');
        sb.append("description:").append(this.description).append(' ');
        sb.append("state:").append((Object)this.state).append(' ');
        sb.append("used:").append(this.usedSizeInBytes).append(' ');
        sb.append("allocated:").append(this.allocatedSpaceInBytes).append(' ');
        return sb.toString();
    }

    public String getVoGroup() {
        return this.voGroup;
    }

    public void setVoGroup(String voGroup) {
        this.voGroup = voGroup;
    }

    public String getVoRole() {
        return this.voRole;
    }

    public void setVoRole(String voRole) {
        this.voRole = voRole;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public AccessLatency getAccessLatency() {
        return this.accessLatency;
    }

    public void setAccessLatency(AccessLatency accessLatency) {
        this.accessLatency = accessLatency;
    }

    public long getUsedSizeInBytes() {
        return this.usedSizeInBytes;
    }

    public long getAllocatedSpaceInBytes() {
        return this.allocatedSpaceInBytes;
    }

    public long getAvailableSpaceInBytes() {
        return this.sizeInBytes - this.usedSizeInBytes - this.allocatedSpaceInBytes;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }
}

