/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

public enum SpaceState {
    RESERVED(0, false),
    RELEASED(1, true),
    EXPIRED(2, true);

    private final int stateId;
    private final boolean isFinal;

    private SpaceState(int stateId, boolean isFinal) {
        this.stateId = stateId;
        this.isFinal = isFinal;
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public static SpaceState valueOf(int stateId) throws IllegalArgumentException {
        for (SpaceState state : SpaceState.values()) {
            if (state.stateId != stateId) continue;
            return state;
        }
        throw new IllegalArgumentException("Unknown state id: " + stateId);
    }
}

