/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import com.google.common.base.Optional;
import diskCacheV111.util.CacheException;
import java.util.Set;
import org.dcache.util.Checksum;

public class FileCorruptedCacheException
extends CacheException {
    private final Optional<Set<Checksum>> _expectedChecksums;
    private final Optional<Set<Checksum>> _actualChecksums;
    private final Optional<Long> _expectedSize;
    private final Optional<Long> _actualSize;

    public FileCorruptedCacheException(String message) {
        super(10004, message);
        this._expectedChecksums = Optional.absent();
        this._actualChecksums = Optional.absent();
        this._expectedSize = Optional.absent();
        this._actualSize = Optional.absent();
    }

    public FileCorruptedCacheException(String message, Throwable cause) {
        super(10004, message, cause);
        this._expectedChecksums = Optional.absent();
        this._actualChecksums = Optional.absent();
        this._expectedSize = Optional.absent();
        this._actualSize = Optional.absent();
    }

    public FileCorruptedCacheException(Set<Checksum> expectedChecksums, Set<Checksum> actualChecksums) {
        super(10004, "Checksum mismatch (expected=" + expectedChecksums + ", actual=" + actualChecksums + ")");
        this._expectedChecksums = Optional.of(expectedChecksums);
        this._actualChecksums = Optional.of(actualChecksums);
        this._expectedSize = Optional.absent();
        this._actualSize = Optional.absent();
    }

    public FileCorruptedCacheException(long expectedSize, long actualSize) {
        super(10004, "File size mismatch (expected=" + expectedSize + ", actual=" + actualSize + ")");
        this._expectedChecksums = Optional.absent();
        this._actualChecksums = Optional.absent();
        this._expectedSize = Optional.of((Object)expectedSize);
        this._actualSize = Optional.of((Object)actualSize);
    }

    public Optional<Set<Checksum>> getExpectedChecksums() {
        return this._expectedChecksums;
    }

    public Optional<Set<Checksum>> getActualChecksums() {
        return this._actualChecksums;
    }

    public Optional<Long> getExpectedSize() {
        return this._expectedSize;
    }

    public Optional<Long> getActualSize() {
        return this._actualSize;
    }
}

