/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.dcache.util.Glob;

public class VOInfo
implements Serializable {
    private static final long serialVersionUID = -8014669884189610627L;
    private static final Pattern p1 = Pattern.compile("(.*)/Role=(.*)");
    private static final Pattern p2 = Pattern.compile("(.*)()");
    private String voGroup;
    private String voRole;

    public VOInfo(String pattern) {
        Matcher m = this.getMatcher(pattern);
        this.voGroup = m.group(1);
        this.voRole = this.mapRoleToGlob(m.group(2));
    }

    private String mapRoleToGlob(String roleInFqan) {
        return roleInFqan.isEmpty() ? "*" : roleInFqan;
    }

    private Matcher getMatcher(String pattern) {
        Matcher m = p1.matcher(pattern);
        if (m.matches()) {
            return m;
        }
        m = p2.matcher(pattern);
        if (m.matches()) {
            return m;
        }
        throw new RuntimeException("Failed to find a matcher for FQAN pattern: " + pattern);
    }

    public VOInfo(String voGroup, String voRole) {
        this.voGroup = voGroup;
        this.voRole = voRole;
    }

    public String toString() {
        return this.voGroup + ":" + this.voRole;
    }

    @Nullable
    public String getVoGroup() {
        return this.voGroup;
    }

    @Nullable
    public String getVoRole() {
        return this.voRole;
    }

    public int hashCode() {
        return Objects.hashCode(this.voGroup) ^ Objects.hashCode(this.voRole);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VOInfo)) {
            return false;
        }
        VOInfo voinfo = (VOInfo)o;
        return Objects.equals(this.voGroup, voinfo.voGroup) && Objects.equals(this.voRole, voinfo.voRole);
    }

    public boolean match(String group, String role) {
        boolean roleMatches;
        if (this.voGroup == null) {
            return false;
        }
        if (this.voRole != null) {
            Glob rolePattern = new Glob(this.voRole);
            roleMatches = rolePattern.matches(role == null ? "null" : role);
        } else {
            roleMatches = true;
        }
        Glob groupPattern = new Glob(this.voGroup);
        return groupPattern.matches(group == null ? "null" : group) && roleMatches;
    }
}

