/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;

public class DCapProtocolInfo
implements IpProtocolInfo {
    private final String _name;
    private final int _minor;
    private final int _major;
    private InetSocketAddress _addr;
    private long _transferTime;
    private long _bytesTransferred;
    private int _sessionId;
    private boolean _writeAllowed;
    private boolean _isPassive;
    private CellPath _door;
    private static final long serialVersionUID = 7432555710192378884L;

    public DCapProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._addr = addr;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(int sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    public String getProtocol() {
        return this._name;
    }

    @Override
    public int getMinorVersion() {
        return this._minor;
    }

    @Override
    public int getMajorVersion() {
        return this._major;
    }

    @Override
    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this._bytesTransferred = bytesTransferred;
    }

    public void setTransferTime(long transferTime) {
        this._transferTime = transferTime;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString()).append(',');
        sb.append(this._addr.getAddress().getHostAddress());
        sb.append(":").append(this._addr.getPort());
        return sb.toString();
    }

    public boolean isWriteAllowed() {
        return this._writeAllowed;
    }

    public void setAllowWrite(boolean allow) {
        this._writeAllowed = allow;
    }

    public boolean isPassive() {
        return this._isPassive;
    }

    public void isPassive(boolean passive) {
        this._isPassive = passive;
    }

    public CellPath door() {
        return this._door;
    }

    public void door(CellPath door) {
        this._door = door;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this._addr;
    }
}

