/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.ProtocolInfo;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.dcache.vehicles.FileAttributes;

@ParametersAreNonnullByDefault
public class DoorTransferFinishedMessage
extends Message {
    private final ProtocolInfo _protocol;
    private FileAttributes _fileAttributes;
    private final PnfsId _pnfsId;
    private final String _poolName;
    private final String _ioQueueName;
    private static final long serialVersionUID = -7563456962335030196L;

    public DoorTransferFinishedMessage(long id, PnfsId pnfsId, ProtocolInfo protocol, FileAttributes fileAttributes, String poolName, @Nullable String ioQueueName) {
        this.setId(id);
        this._fileAttributes = (FileAttributes)Preconditions.checkNotNull((Object)fileAttributes);
        this._protocol = (ProtocolInfo)Preconditions.checkNotNull((Object)protocol);
        this._pnfsId = (PnfsId)Preconditions.checkNotNull((Object)pnfsId);
        this._poolName = (String)Preconditions.checkNotNull((Object)poolName);
        this._ioQueueName = ioQueueName;
    }

    public String getIoQueueName() {
        return this._ioQueueName;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocol;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public String getPoolName() {
        return this._poolName;
    }

    @Override
    public String getDiagnosticContext() {
        return super.getDiagnosticContext() + " " + this.getPnfsId();
    }
}

