/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GenericStorageInfo
implements StorageInfo {
    private static final long serialVersionUID = 2089636591513548893L;
    @Deprecated
    private AccessLatency _accessLatency = StorageInfo.DEFAULT_ACCESS_LATENCY;
    @Deprecated
    private RetentionPolicy _retentionPolicy = StorageInfo.DEFAULT_RETENTION_POLICY;
    private Map<String, String> _keyHash = new HashMap<String, String>();
    private List<URI> _locations = new ArrayList<URI>();
    private boolean _setHsm;
    private boolean _setStorageClass;
    private boolean _setBitFileId;
    private boolean _setLocation;
    private boolean _isNew = true;
    private boolean _isStored;
    private String _hsm;
    private String _cacheClass;
    @Deprecated
    private long _fileSize;
    private String _storageClass;
    @Deprecated
    private String _bitfileId;

    public GenericStorageInfo() {
    }

    public GenericStorageInfo(String hsm, String storageClass) {
        this._storageClass = storageClass;
        this._hsm = hsm;
    }

    @Deprecated
    public void addKeys(Map<String, String> keys) {
        this._keyHash.putAll(keys);
    }

    @Override
    public void addLocation(URI newLocation) {
        this._locations.add(newLocation);
    }

    @Override
    @Deprecated
    public String getBitfileId() {
        return this._bitfileId == null ? "<Unknown>" : this._bitfileId;
    }

    @Override
    public String getCacheClass() {
        return this._cacheClass;
    }

    @Override
    public String getHsm() {
        return this._hsm;
    }

    @Override
    @Deprecated
    public String getKey(String key) {
        return this._keyHash.get(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getMap() {
        return new HashMap<String, String>(this._keyHash);
    }

    @Override
    public String getStorageClass() {
        return this._storageClass;
    }

    @Override
    public boolean isCreatedOnly() {
        return this._isNew;
    }

    @Override
    public boolean isSetAddLocation() {
        return this._setLocation;
    }

    @Override
    public void isSetAddLocation(boolean isSet) {
        this._setLocation = isSet;
    }

    @Override
    @Deprecated
    public boolean isSetBitFileId() {
        return this._setBitFileId;
    }

    @Override
    @Deprecated
    public void isSetBitFileId(boolean isSet) {
        this._setBitFileId = isSet;
    }

    @Override
    public void setCacheClass(String newCacheClass) {
        this._cacheClass = newCacheClass;
    }

    @Override
    public boolean isSetHsm() {
        return this._setHsm;
    }

    @Override
    public void isSetHsm(boolean isSet) {
        this._setHsm = isSet;
    }

    @Override
    public boolean isSetStorageClass() {
        return this._setStorageClass;
    }

    @Override
    public void isSetStorageClass(boolean isSet) {
        this._setStorageClass = isSet;
    }

    @Override
    public boolean isStored() {
        return this._isStored || this._locations != null && !this._locations.isEmpty();
    }

    @Override
    public List<URI> locations() {
        return this._locations;
    }

    @Override
    @Deprecated
    public void setBitfileId(String bitfileId) {
        this._bitfileId = bitfileId;
    }

    @Override
    public void setHsm(String newHsm) {
        this._hsm = newHsm;
    }

    @Override
    public void setIsNew(boolean isNew) {
        this._isNew = isNew;
    }

    @Override
    @Deprecated
    public String setKey(String key, String value) {
        if (value == null) {
            return this._keyHash.remove(key);
        }
        return this._keyHash.put(key, value);
    }

    @Override
    public void setStorageClass(String newStorageClass) {
        this._storageClass = newStorageClass;
    }

    @Override
    @Deprecated
    public void setIsStored(boolean isStored) {
        this._isStored = isStored;
    }

    @Override
    public String toString() {
        String sc = this.getStorageClass();
        String cc = this.getCacheClass();
        String hsm = this.getHsm();
        AccessLatency ac = this.getLegacyAccessLatency();
        RetentionPolicy rp = this.getLegacyRetentionPolicy();
        StringBuilder sb = new StringBuilder();
        sb.append("size=").append(this.getLegacySize()).append(";new=").append(this.isCreatedOnly()).append(";stored=").append(this.isStored()).append(";sClass=").append(sc == null ? "-" : sc).append(";cClass=").append(cc == null ? "-" : cc).append(";hsm=").append(hsm == null ? "-" : hsm).append(";accessLatency=").append(ac == null ? "-" : ac.toString()).append(";retentionPolicy=").append(rp == null ? "-" : rp.toString()).append(";");
        if (this._keyHash != null) {
            for (Map.Entry entry : this._keyHash.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(key).append("=").append(value).append(";");
            }
        }
        if (this._locations != null) {
            for (URI uRI : this._locations) {
                sb.append(uRI).append(";");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        HashSet<URI> ourLocations = new HashSet<URI>(this.locations());
        return this.getLegacyAccessLatency().hashCode() ^ this.getLegacyRetentionPolicy().hashCode() ^ ourLocations.hashCode() ^ (int)this.getLegacySize() ^ this.getStorageClass().hashCode() ^ (this.isStored() ? 1 : 0) ^ (this.isCreatedOnly() ? 2 : 0);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericStorageInfo)) {
            return false;
        }
        GenericStorageInfo other = (GenericStorageInfo)o;
        if (!other.getLegacyAccessLatency().equals((Object)this.getLegacyAccessLatency())) {
            return false;
        }
        if (!other.getLegacyRetentionPolicy().equals((Object)this.getLegacyRetentionPolicy())) {
            return false;
        }
        HashSet<URI> ourLocations = new HashSet<URI>(this.locations());
        HashSet<URI> otherLocations = new HashSet<URI>(other.locations());
        if (!otherLocations.equals(ourLocations)) {
            return false;
        }
        if (this.locations().isEmpty()) {
            if (other.getBitfileId() != null && this.getBitfileId() != null && !other.getBitfileId().equals(this.getBitfileId())) {
                return false;
            }
            if (other.getBitfileId() != null && this.getBitfileId() == null) {
                return false;
            }
            if (other.getBitfileId() == null && this.getBitfileId() != null) {
                return false;
            }
        }
        if (!Objects.equals(other.getHsm(), this.getHsm())) {
            return false;
        }
        if (!Objects.equals(other.getCacheClass(), this.getCacheClass())) {
            return false;
        }
        if (!Objects.equals(other._keyHash, this._keyHash)) {
            return false;
        }
        if (other.getLegacySize() != this.getLegacySize()) {
            return false;
        }
        if (!Objects.equals(other.getStorageClass(), this.getStorageClass())) {
            return false;
        }
        if (other.isStored() != this.isStored()) {
            return false;
        }
        return other.isCreatedOnly() == this.isCreatedOnly();
    }

    Object readResolve() {
        if (this._accessLatency == null) {
            this._accessLatency = AccessLatency.NEARLINE;
        }
        if (this._retentionPolicy == null) {
            this._retentionPolicy = RetentionPolicy.CUSTODIAL;
        }
        if (this._locations == null) {
            this._locations = new ArrayList<URI>();
        }
        return this;
    }

    @Override
    public GenericStorageInfo clone() {
        try {
            GenericStorageInfo copy = (GenericStorageInfo)super.clone();
            copy._keyHash = new HashMap<String, String>(this._keyHash);
            copy._locations = new ArrayList<URI>(this._locations);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone storage info: " + e.getMessage());
        }
    }

    public static StorageInfo valueOf(String storeUnit, String cacheClass) throws IllegalArgumentException {
        GenericStorageInfo si;
        if (storeUnit.equals("*")) {
            si = new GenericStorageInfo();
        } else {
            String[] unitParts = storeUnit.split("@");
            if (unitParts.length != 2) {
                throw new IllegalArgumentException("Invalid format: expected<x:y@z> got <" + storeUnit + ">");
            }
            si = new GenericStorageInfo(unitParts[1], unitParts[0]);
        }
        if (!cacheClass.equals("*")) {
            si.setCacheClass(cacheClass);
        }
        return si;
    }

    @Override
    public void setLegacyAccessLatency(AccessLatency al) {
        this._accessLatency = al;
    }

    @Override
    public AccessLatency getLegacyAccessLatency() {
        return this._accessLatency;
    }

    @Override
    public void setLegacyRetentionPolicy(RetentionPolicy rp) {
        this._retentionPolicy = rp;
    }

    @Override
    public RetentionPolicy getLegacyRetentionPolicy() {
        return this._retentionPolicy;
    }

    @Override
    public long getLegacySize() {
        return this._fileSize;
    }

    @Override
    public void setLegacySize(long fileSize) {
        this._fileSize = fileSize;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._keyHash != null) {
            this._keyHash = this._keyHash.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).intern(), e -> (String)e.getValue()));
        }
        if (this._storageClass != null) {
            this._storageClass = this._storageClass.intern();
        }
        if (this._cacheClass != null) {
            this._cacheClass = this._cacheClass.intern();
        }
        if (this._hsm != null) {
            this._hsm = this._hsm.intern();
        }
    }
}

