/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IoDoorEntry
implements Serializable {
    private final long _serialId;
    private final PnfsId _pnfsId;
    private String _pool;
    private final String _status;
    private final long _waitingSince;
    private final String _replyHost;
    private static final long serialVersionUID = 7283617314269359997L;

    public IoDoorEntry(long serialId, PnfsId pnfsId, String pool, String status, long waitingSince, String replyHost) {
        this._serialId = serialId;
        this._pnfsId = pnfsId;
        this._pool = pool;
        this._status = status;
        this._waitingSince = waitingSince;
        this._replyHost = (String)Preconditions.checkNotNull((Object)replyHost);
    }

    public long getSerialId() {
        return this._serialId;
    }

    @Nullable
    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Nullable
    public String getPool() {
        return this._pool;
    }

    @Nullable
    public String getStatus() {
        return this._status;
    }

    public long getWaitingSince() {
        return this._waitingSince;
    }

    @Nonnull
    public String getReplyHost() {
        return this._replyHost;
    }

    public String toString() {
        return this._serialId + ";" + this._pnfsId + ";" + this._replyHost + ";" + this._pool + ";" + this._status + ";" + (System.currentTimeMillis() - this._waitingSince) + ";";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._pool != null) {
            this._pool = this._pool.intern();
        }
    }
}

