/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JobInfo
implements Serializable {
    private static final SimpleDateFormat __format = new SimpleDateFormat("MM/dd-HH:mm:ss");
    private static final long serialVersionUID = 5209798222006083955L;
    private final String _client;
    private final long _clientId;
    private final long _submitTime;
    private final long _startTime;
    private String _status;
    private final long _jobId;

    public JobInfo(long submitTime, long startTime, String status, int id, String clientName, long clientId) {
        this._submitTime = submitTime;
        this._startTime = startTime;
        this._status = (String)Preconditions.checkNotNull((Object)status);
        this._jobId = id;
        this._client = clientName;
        this._clientId = clientId;
    }

    public String getClientName() {
        return this._client;
    }

    public long getClientId() {
        return this._clientId;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getSubmitTime() {
        return this._submitTime;
    }

    public String getStatus() {
        return this._status;
    }

    public long getJobId() {
        return this._jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._jobId).append(";");
        sb.append(this._client).append(":").append(this._clientId);
        SimpleDateFormat simpleDateFormat = __format;
        synchronized (simpleDateFormat) {
            sb.append(";").append(__format.format(new Date(this._startTime))).append(";").append(__format.format(new Date(this._submitTime))).append(";").append(this._status).append(";");
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._status = this._status.intern();
    }
}

