/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import diskCacheV111.util.FsPath;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.namespace.CreateOption;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PnfsCommitUpload
extends PnfsMessage {
    private final String uploadPath;
    private final Set<FileAttribute> requestedAttributes;
    private final Set<CreateOption> options;
    private FileAttributes fileAttributes;

    public PnfsCommitUpload(Subject subject, FsPath uploadPath, FsPath path, Set<CreateOption> options, Set<FileAttribute> requestedAttributes) {
        this.setSubject(subject);
        this.setPnfsPath(path.toString());
        this.setReplyRequired(true);
        this.options = options;
        this.requestedAttributes = requestedAttributes;
        this.uploadPath = uploadPath.toString();
    }

    public FsPath getPath() {
        return new FsPath(this.getPnfsPath());
    }

    public FsPath getUploadPath() {
        return new FsPath(this.uploadPath);
    }

    public Set<CreateOption> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public Set<FileAttribute> getRequestedAttributes() {
        return Sets.newHashSet((Iterable)Iterables.concat(this.requestedAttributes, Collections.singleton(FileAttribute.PNFSID)));
    }

    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public void setFileAttributes(FileAttributes fileAttributes) {
        if (fileAttributes.isDefined(FileAttribute.PNFSID)) {
            this.setPnfsId(fileAttributes.getPnfsId());
        }
        this.fileAttributes = fileAttributes;
    }
}

