/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.collect.Sets;
import diskCacheV111.vehicles.Message;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.PnfsGetFileAttributes;

public class PnfsCreateEntryMessage
extends PnfsGetFileAttributes {
    private final String _path;
    private final int _uid;
    private final int _gid;
    private final int _mode;
    private static final long serialVersionUID = -8197311585737333341L;

    public PnfsCreateEntryMessage(String path) {
        this(path, -1, -1, -1);
    }

    public PnfsCreateEntryMessage(String path, Set<FileAttribute> attr) {
        this(path, -1, -1, -1, attr);
    }

    public PnfsCreateEntryMessage(String path, int uid, int gid, int mode) {
        this(path, uid, gid, mode, Collections.emptySet());
    }

    public PnfsCreateEntryMessage(String path, int uid, int gid, int mode, Set<FileAttribute> attr) {
        super(path, EnumSet.copyOf(Sets.union(attr, EnumSet.of(FileAttribute.OWNER, new FileAttribute[]{FileAttribute.OWNER_GROUP, FileAttribute.MODE, FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.CREATION_TIME, FileAttribute.ACCESS_TIME, FileAttribute.MODIFICATION_TIME, FileAttribute.PNFSID, FileAttribute.STORAGEINFO, FileAttribute.STORAGECLASS, FileAttribute.CACHECLASS, FileAttribute.HSM, FileAttribute.ACCESS_LATENCY, FileAttribute.RETENTION_POLICY}))));
        this._path = path;
        this._uid = uid;
        this._gid = gid;
        this._mode = mode;
    }

    public String getPath() {
        return this._path;
    }

    public int getUid() {
        return this._uid;
    }

    public int getGid() {
        return this._gid;
    }

    public int getMode() {
        return this._mode;
    }

    @Override
    public boolean invalidates(Message message) {
        return this.genericInvalidatesForPnfsMessage(message);
    }

    @Override
    public boolean fold(Message message) {
        return false;
    }
}

